//
//  WMImageUploadOperation.h
//  Gengmei
//
//  Created by Sean Lee on 4/7/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void (^ImageUploadFinishBlock)(NSDictionary * JSON);

@interface WMOperationQueue : NSOperationQueue
@end

@interface WMImageUploadOperation : NSOperation

@property (nonatomic, copy)  ImageUploadFinishBlock imageUploadFinishBlock;


/**
 *  由外部传进来params
 */
@property (nonatomic, strong) NSDictionary *params;


/*!
 *  @author zhaiguojun, 16-04-15
 *
 *  @brief 默认压缩率的上传
 *
 *  @param image
 *  @param url
 *
 *  @return
 *
 *  @since 0.0.1
 */
- (instancetype)initWithImage:(UIImage *)image url:(NSString *)url;

/*!
 *  @author zhaiguojun, 16-04-15
 *
 *  @brief 指定压缩率的上传图片
 *
 *  @param image
 *  @param url
 *  @param compressionQuality 压缩率
 *
 *  @return
 *
 *  @since 0.0.1
 */
- (instancetype)initWithImage:(UIImage *)image  url:(NSString *)url withCompressionQuality:(float)compressionQuality;

/*!
 *  @author zhaiguojun, 16-04-15
 *
 *  @brief startUpload
 *
 *  @since 0.0.1
 */
- (void)startUpload;

@end
