//
//  GMBaseUtil.m
//  Gengmei
//
//  Created by wangyang on 16/7/9.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMBaseUtil.h"
@import GMKit;
@import Masonry;

@implementation UIFont (GMBase)
+ (UIFont *)navigationFontWithSize:(NSInteger)size {
    UIFont *font = [UIFont systemFontOfSize:size];
    return font;
}
@end

@implementation UIColor (GMBase)
+ (UIColor *)colorWithhex:(NSInteger)hex {
    return [UIColor colorWithRed: (((hex >> 16) & 0xFF))/255.0f
                    green: (((hex >> 8) & 0xFF))/255.0f
                     blue: ((hex & 0xFF))/255.0f
                    alpha: 1];
}
@end

@implementation UIView (GMAdditions)
- (MASViewAttribute *)mas_safeBottom {
    if (SYSTEM_VERSION_GREATER_THAN_OR_EQUAL_TO(@"11.0")) {
        return [[MASViewAttribute alloc] initWithView:self item:self.safeAreaLayoutGuide layoutAttribute:NSLayoutAttributeBottom];
    } else {
        return [[MASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeBottom];
    }
}
@end

@implementation MASConstraintMaker (GMAdditions)
- (void)mas_bottomToSuperView:(UIView *)view withHeight:(CGFloat)height {
    self.top.equalTo(view.mas_safeBottom).offset(-height);
    self.bottom.mas_equalTo(0);
}
@end


