//
//  GMActionSheet.swift
//  Gengmei
//
//  Created by 汪俊 on 2017/2/7.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

import UIKit
//import GMBaseSwift

/// item文字的颜色
@objc public enum GMActionSheetItemType: Int {
    case `default`   // 默认
    case cancel    // 取消
}

/// alertView item的数据
public struct GMActionSheetItemObject {
    var title: String
    var type: GMActionSheetItemType
    var color: UIColor
    var handler: ItemClickBlock?
    init(title: String, type: GMActionSheetItemType, color: UIColor, block: ItemClickBlock?) {
        self.title = title
        self.type = type
        self.color = color
        self.handler = block
    }
}

public typealias ItemClickBlock = (_ index: Int) -> Void

/// 日记本详情页编辑日记本弹出的自定义的一个alertView,从底部向上弹出
@objcMembers
public class GMActionSheet: GMView {
    fileprivate let tableView = GMTableView(frame: .zero, style: .grouped)
    fileprivate var itemObjs = [GMActionSheetItemObject]()
    fileprivate let coverBackView = GMView()
    fileprivate var alertTitle = ""
    fileprivate var cancelItemObj = GMActionSheetItemObject(title: "", type: .cancel, color: UIColor.headlineText, block: nil)
    public override func setup() {
        super.setup()
        self.backgroundColor = UIColor.white
        coverBackView.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(coverBackTapAction)))
        coverBackView.backgroundColor = UIColor.black
        coverBackView.alpha = 0
        coverBackView.frame = Constant.screenBounds
        tableView.registerCell(GMActionSheetCell.classForCoder())
        tableView.isScrollEnabled = false
        backgroundColor = UIColor.background
        addSubview(tableView)
        tableView.frame = CGRect(x: 0, y: 0, width: Constant.screenWidth, height: 0)
        tableView.rowHeight = 49
        tableView.delegate = self
        tableView.dataSource = self
    }
    
    // 添加alert title
    public func addAlertTitle(_ title: String, color: UIColor) {
        alertTitle = title
        if title.isEmpty {
            return
        }
        let header = GMView(frame: CGRect(x: 0, y: 0, width: Constant.screenWidth, height: 49))
        header.backgroundColor = UIColor.white
        let headerTitle = GMLabel(textColor: color, fontSize: 16)
        headerTitle.textAlignment = .center
        headerTitle.frame = CGRect(x: 0, y: 0, width: Constant.screenWidth, height: 49)
        headerTitle.text = title
        header.addSubview(headerTitle)
        header.addBottomLine()
        self.tableView.tableHeaderView = header
    }

    public func addItem(title: String, style: GMActionSheetItemType, color: UIColor, handle: ItemClickBlock? = nil) {
        if style == .default {
            let itemObj = GMActionSheetItemObject(title: title, type: style, color: color, block: handle)
            itemObjs.append(itemObj)
        } else {
            cancelItemObj = GMActionSheetItemObject(title: title, type: style, color: color, block: handle)
        }
    }
}

// MARK: - UITableViewDataSource, UITableViewDelegate
@objc  extension GMActionSheet: UITableViewDataSource, UITableViewDelegate {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 2
    }
    
    public func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == 0 {
            return itemObjs.count
        }
        return 1
    }
    
    public func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeue(cell: GMActionSheetCell.classForCoder(), for: indexPath) as! GMActionSheetCell
            if indexPath.section == 0 {
                let obj = itemObjs[indexPath.row]
                cell.label.text = obj.title
                cell.label.textColor = obj.color
                cell.bottomLine.isHidden = (indexPath.row == itemObjs.count - 1)
            } else {
                cell.label.text = cancelItemObj.title
                cell.label.textColor = cancelItemObj.color
            }
            return cell
    }
    
    public func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        if section == 0 {
            return UIView()
        } else {
            return nil
        }
    }
    
    public func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        if section == 0 {
            return 10
        } else {
            return 0
        }
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if indexPath.section == 0 {
            if itemObjs[indexPath.row].handler != nil {
                itemObjs[indexPath.row].handler!(indexPath.row)
            }
            hide()
        } else {
            if cancelItemObj.handler != nil {
                cancelItemObj.handler!(indexPath.row)
            }
            hide()
        }
    }
    
    override public func willMove(toSuperview newSuperview: UIView?) {
        if newSuperview != nil {
            tableView.reloadData()
            var itemCout = 0
            if alertTitle.isEmpty {
                itemCout = itemObjs.count + 1
            } else {
                itemCout = itemObjs.count + 2
            }
            let alertViewHeight = itemCout * 49 + 10
            tableView.height = CGFloat(alertViewHeight)

            var resizedHeight = CGFloat(alertViewHeight)
            if #available(iOS 11.0, *) {
                resizedHeight += newSuperview!.safeAreaInsets.bottom
            }
            self.frame = CGRect(x: 0, y: Constant.screenHeight, width: Constant.screenWidth, height: resizedHeight)
            UIView.animate(withDuration: 0.25, animations: {
                self.top = Constant.screenHeight - self.height
                self.coverBackView.alpha = 0.5
            }) 
        }
    }
}

// MARK: - action
@objc extension GMActionSheet {
    public dynamic func show() {
        UIApplication.shared.keyWindow?.addSubview(coverBackView)
        UIApplication.shared.keyWindow?.addSubview(self)
    }
    
    public dynamic func hide() {
        UIView.animate(withDuration: 0.25, animations: {
            self.top = Constant.screenHeight
            self.coverBackView.alpha = 0
        }, completion: { (_) in
            self.removeFromSuperview()
            self.coverBackView.removeFromSuperview()
        }) 
    }
    
    @objc dynamic func coverBackTapAction() {
        hide()
    }
}

@objcMembers
class GMActionSheetCell: GMTableViewCell {
    var label = GMLabel(textAlignment: .center, backgroundColor: UIColor.clear, textColor: UIColor.headlineText, fontSize: 15)
    
    override func setup() {
        super.setup()
        contentView.addSubview(label)
        label.snp.makeConstraints { (make) in
            make.edges.equalTo(UIEdgeInsets.zero)
        }
    }
}
