//
//  WMTagView.swift
//  test
//
//  Created by wangyang on 15/12/8.
//  Copyright © 2015年 Wanmiechuangyi. All rights reserved.
//

import UIKit
//import GMBaseSwift

/*
 高效的，可以在table及collectionView中使用的tagView。
 现在用在了日记本卡片中，以保证首页流畅度。其它地方涉及需求时再改动
 */
@objcMembers
class WYTagView: GMView {

    /// 在layoutsubview中使用该属性最后设置self的宽度
    var maxWidth: CGFloat = Constant.screenWidth
    var tapBlock: ((_ index: Int) -> Void)?
    var tags: [String] = [] {
        didSet {
            for (index, view) in self.subviews.enumerated() {
                let label = view as! GMLabel
                // 如果视图的index超过数据的长度，则隐藏
                if index >= tags.count {
                    label.isHidden = true
                } else {
                    label.isHidden = false
                    label.text = tags[index]
                }
            }
        }
    }

    override func layoutSubviews() {
        super.layoutSubviews()
        // 如果视图的right已经超过最大宽度，则隐藏
        for (index, label) in self.subviews.enumerated() where label.frame.maxX > self.maxWidth {
            // 经过产品王昕 确认iOS 如果超出显示...
            if index > 0 {
                label.isHidden = true
            } else {
                label.width = self.maxWidth
            }
        }
    }

    /// 在初始化方法
    ///
    /// - Parameters:
    ///   - maxWidth: 最大宽度
    ///   - maxTagCount: 预估的tag label最大个数
    ///   - tagSpace: tag之间的距离
    ///   - customLabelUI: 自定义tag label的UI
    convenience init(maxWidth: CGFloat, maxTagCount: Int, tagSpace: CGFloat, customLabelUI: ((GMLabel) -> Void)?) {
        self.init()
        self.maxWidth = maxWidth
        // self不剪切，以显示全部的Label内容。见下面label.centerY的约束
        clipsToBounds = false

        var preLabel: UIView! = nil
        for i in 0..<maxTagCount {
            let label = GMLabel(frame: CGRect(x: 0, y: 0, width: self.bounds.size.width, height: self.bounds.size.height))
            label.textColor = UIColor.mainVisual
            label.font = UIFont.gmFont(13)
            label.backgroundColor = UIColor.clear
            label.layer.masksToBounds = true
            addSubview(label)
            label.snp.makeConstraints({ (make) in
                if i == 0 {
                    make.left.equalTo(0)
                } else {
                    make.left.equalTo(preLabel.snp.right).offset(tagSpace)
                }
                make.centerY.equalToSuperview()
            })
            preLabel = label
            customLabelUI?(label)
        }

        // 点击手势：注意，是加在self上的，而不是每个label一个
        let tap = UITapGestureRecognizer(target: self, action: #selector(WYTagView.tapAction(_:)))
        addGestureRecognizer(tap)
    }

    @objc private func tapAction(_ tap: UITapGestureRecognizer) {
        // 因为 pointInside:withEvent已经保证了是点击了tagView，那么剩下只需要判断点击的x是在哪个label范围就行了。
        // 所以强制生成一个CGPoint(x: point.x, y: 0)，只计算x范围
        let point = tap.location(in: self)
        for (i, view) in self.subviews.enumerated() {
            if view.frame.minX < point.x && view.frame.maxX > point.x {
                tapBlock?(i)
                break
            }
        }
    }

    /// 为tag增加一点热区，主要是y方向，并且只在点击到了subview，才算作命中
    override func point(inside point: CGPoint, with event: UIEvent?) -> Bool {
        if gm_point(inside: point, with: event) {
            for view in self.subviews {
                // 视图没有被隐藏，并且在视图的范围内
                if !view.isHidden &&
                    view.frame.minX < point.x && view.frame.maxX > point.x {
                    return true
                }
            }
            return false
        } else {
            return false
        }
    }
}
