//
//  GMListViewController.m
//  GMBase
//
//  Created by wangyang on 16/7/11.
//  Copyright © 2016年 wangyang. All rights reserved.
//

#import "GMListViewController.h"
#import "GMListViewModel.h"

@interface GMListViewController ()

@end

@implementation GMListViewController
@synthesize viewModel;

- (void)initController {
    [super initController];
    self.viewModel = [GMListViewModel new];
    _cellHeight = 40;
    _cellIdentifier = @"cell";
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationBar.title = @"列表";
    self.navigationBar.rightTitle = @"没什么用";
    _table.separatorStyle = UITableViewCellSeparatorStyleSingleLine;
    [_table registerClass:[UITableViewCell class] forCellReuseIdentifier:@"cell"];
}

- (void)updateOtherUIData {
    [super updateOtherUIData];
}

- (void)configDataForCell:(UITableViewCell *)cell atIndexPath:(NSIndexPath *)indexPath {
    cell.textLabel.text = [self.viewModel.dataArray[indexPath.row] valueForKey:@"content"];
}

- (void)rightButtonClicked:(OCNavigatioinBarButton *)button {
    NSLog(@"没什么用");
}


@end
