//
//  UIViewController+HUD.h
//  Pods
//
//  Created by wangyang on 16/7/11.
//
//

#import <UIKit/UIKit.h>
#import <MBProgressHUD/MBProgressHUD.h>
@interface UIViewController (HUD)
/**
 *	@brief 显示加载动画
 *	@param text 加载动画文字
 */
- (void)showLoading:(NSString *) text;

/**
 *	@brief 显示隐藏加载
 *	@param text 警告文字
 */
- (void)hideLoading;

/**
 *	@brief 显示完成信息，1秒后消失
 *	@param text 文字
 */
- (void)showComplete:(NSString *)text;

/**
 *	@brief 显示警告或错误信息，1秒后消失
 *	@param text 警告文字
 */
- (void)showWarning:(NSString *)text;

/**
 *  @brief  toast
 *
 *  @param text 仅显示文字提示
 */
- (void)toast:(NSString *)text;

- (void)toastInView:(NSString *)text;
@end
