//
//  WMBaseViewController.h
//  Gengmei
//
//  Created by 老邢Thierry on 13-9-27. Maintain by iOS Team Member. Rewrite by 汪洋 in 2016-7-8.
//  Copyright (c) 2014 Wanmeichuangyi. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OCNavigatioinBar.h"
#import "UIViewController+HUD.h"

@interface WMBaseViewController : UIViewController <OCNavigatioinBarDelegate>
@property (nonatomic, strong) OCNavigatioinBar *navigationBar;
/**
 *  @brief  因为controller会有initWithCoder，init，initWithNib三种方式，为了避免子类代码的疏忽导致父类自定义init内容没有覆盖到，所以统一使用initController方法。需要调用super
 */
- (void)initController __attribute__((objc_requires_super));
- (void)pushViewController:(UIViewController *)controller;
@end


#pragma mark - 埋点
@interface UIViewController (Phobos)
/**
 *  @author 翟国钧, 16-02-24 17:02:22
 *
 *  @brief 埋点的时候，有些埋点都需要业务id，比如DoctorId，针对那些只能在父类中埋点的业务，要在子类中设置当前id，然后在父类中取到
 *  在一些详情页的分享和收藏的时候，由于分享、收藏的方法在basewebview里，所以，统一在里面做处理，但是需要在子类中把想要的参数传过去。包括：type（类型）、from（来自哪）、businessId（对应业务id）
 *  @since 5.9.1
 */
@property (nonatomic , copy) NSString *businessId;

/**
 *  @author 翟国钧  in 16-02-25 19:02:32
 *
 *  @brief 获取前一个页面的pageName
 *
 *  @since 5.9.1
 */
@property (nonatomic, strong, readonly) NSString *referer;

/**
 *  @author 翟国钧 in 16-02-25 19:02:32
 *
 *  埋点pv事件中当前页面的别名
 *  @since 5.9.1
 */
@property (nonatomic, copy) NSString *pageName;
@end
