//
//  BaseViewController.m
//  Gengmei
//
//  Created by 老邢Thierry on 13-9-27. Maintain by iOS Team Member. Rewrite by 汪洋 in 2016-7-8.
//  Copyright (c) 2013年 老邢Thierry. All rights reserved.
//

#import "WMBaseViewController.h"
#import "GMBaseUtil.h"
#import <GMPhobos/Phobos.h>
#import <objc/runtime.h>

@interface WMBaseViewController () {
}

@end

@implementation WMBaseViewController

- (instancetype)init
{
    // 在init方法里调用initWithNibName:bundle，保证了WMBaseViewController里的initWithNibName不会再次被调用，也就是保证了initController方法不会被调用两次
    self = [super initWithNibName:nil bundle:nil];
    if (self) {
        [self initController];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)coder
{
    self = [super initWithCoder:coder];
    if (self) {
        [self initController];
    }
    return self;
}

- (instancetype)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    [self initController];
    return self;
}

- (void)initController{
    self.pageName = @"";
    self.businessId = @"";

    // 在 initController 中初始化自定义导航栏有很大好处。至少可以保证视图被push之前就可以访问navigationBar，以配置title等属性
    [self customNavigationBar];
}

- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor colorWithhex:0xf5f5f5];
    self.edgesForExtendedLayout = UIRectEdgeNone;
    [self addNavigationBar];
    [self hideLeftButtonForRootController];
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];

    // 保证即使在loading的时候，仍然可以后退
    [self.view bringSubviewToFront:self.navigationBar];
}

- (void)didMoveToParentViewController:(UIViewController *)parent {
    [super didMoveToParentViewController:parent];

    // 作为childController使用，但不是被push到 UINavigationController时，隐藏导航栏
    if (parent != nil && ![parent isKindOfClass:[UINavigationController class]]) {
        self.navigationBar.hidden = YES;
    }
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    // 如果栈内的层级多于一个，隐藏UITabBar
    if (self.navigationController.childViewControllers.count >= 1){
        [self setHidesBottomBarWhenPushed:YES];
    }
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    // 导航栏隐藏在 viewWillAppear 里控制的原因是在viewDidLoad时，有可能 navigationController 与 self 并没有关系
    self.navigationController.navigationBarHidden = YES;
    [[Phobos sharedClient] onPageStart:self.pageName businessId:self.businessId referer:[self referer]];
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];

    // 如果栈内的层级小于等于两个，取消隐藏下面的tabbar
    if (self.navigationController.childViewControllers.count <= 2) {
        [self setHidesBottomBarWhenPushed:NO];
    }

    if (self.pageName.length > 0) {
        [[Phobos sharedClient] onPageEnd];
    }
}

- (UIStatusBarStyle)preferredStatusBarStyle{
    return UIStatusBarStyleDefault;
}

#pragma mark - 导航
- (void)customNavigationBar {
    _navigationBar = [[OCNavigatioinBar alloc] initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, 64)];
}

- (void)addNavigationBar {
    _navigationBar.delegate = self;
    [self.view addSubview:_navigationBar];
}

- (void)hideLeftButtonForRootController {
    if (self.navigationController.viewControllers.count == 1) {
        _navigationBar.leftButton.hidden = YES;
    }
}

- (void)setTitle:(NSString *)title {
    [super setTitle:title];
    self.navigationBar.title = title;
}

- (void)pushViewController:(UIViewController *)controller {
    [self.navigationController pushViewController:controller animated:YES];
}

#pragma mark - OCNavigatioinBarDelegate
- (void)nearRightButtonClicked:(OCNavigatioinBarButton *)button {}
- (void)rightButtonClicked:(OCNavigatioinBarButton *)button {}
- (void)backAction:(OCNavigatioinBarButton *)button {
    if ([self.parentViewController isKindOfClass:[UINavigationController class]]) {
        UINavigationController *navigation = (UINavigationController *)self.parentViewController;
        NSArray *controllers = navigation.viewControllers;
        if (self.presentingViewController && controllers.count == 1) {
            [self dismissViewControllerAnimated:YES completion:nil];
        }else{
            [self.navigationController popViewControllerAnimated:YES];
        }
    }else{
        [self dismissViewControllerAnimated:YES completion:nil];
    }
}
@end

#pragma mark - 埋点
@implementation UIViewController (Phobos)
/**
 *  @author 翟国钧, 16-03-01 15:03:24
 *
 *  @brief 取当前导航栈中当前VC的上级VC，如果该VC存在，就获取他的pageName
 *
 *  @return 前一页的pageName
 *
 *  @since 5.9.1
 */
- (NSString *)referer
{
    NSArray *navigationPool = self.navigationController.viewControllers;
    NSInteger refererIndex = navigationPool.count - 2;
    if (refererIndex < 0 ) {
        return @"";
    }

    UIViewController *controller = navigationPool[refererIndex];
    return controller.pageName == nil ? @"" : controller.pageName;
}

- (NSString *)pageName {
    return objc_getAssociatedObject(self, @selector(pageName));
}

- (void)setPageName:(NSString *)pageName {
    objc_setAssociatedObject(self, @selector(pageName), pageName, OBJC_ASSOCIATION_COPY);
}

- (NSString *)businessId {
    return objc_getAssociatedObject(self, @selector(businessId));
}

- (void)setBusinessId:(NSString *)businessId {
    objc_setAssociatedObject(self, @selector(businessId), businessId, OBJC_ASSOCIATION_COPY);
}
@end
