//
//  UIView+Gradient.h
//  Gengmei
//
//  Created by Terminator on 2018/8/15.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIView (Gradient)
@property(nullable, copy) NSArray *colors;
@property(nullable, copy) NSArray<NSNumber *> *locations;
@property CGPoint startPoint;
@property CGPoint endPoint;

+ (UIView *_Nullable)gradientViewWithColors:(NSArray<UIColor *> *_Nullable)colors locations:(NSArray<NSNumber *> *_Nullable)locations startPoint:(CGPoint)startPoint endPoint:(CGPoint)endPoint;

- (void)setGradientBackgroundWithColors:(NSArray<UIColor *> *_Nullable)colors locations:(NSArray<NSNumber *> *_Nullable)locations startPoint:(CGPoint)startPoint endPoint:(CGPoint)endPoint;

/**
 从一个颜色变化到另一个颜色
 
 @param beginColor 开始颜色
 @param endColor 结束颜色
 @param percent 百分比
 */
- (void)getColorWithColor:(UIColor *_Nullable)beginColor endColor:(UIColor *_Nullable)endColor percent:(double)percent;
@end
