//
//  WMLocationManager.h
//  Gengmei
//
//  Created by wangyang on 5/6/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>

#define kLastLocation   @"lastLocation"
typedef void(^LocationFinishBlock)(CLLocation *location);
typedef void(^GMLocationAuthorizationBlock)(CLAuthorizationStatus status);

/**
 保证新用户在有网络的情况下弹出 授权框  不然调不起地理位置弹框

 */
//typedef void(^RequestLocationAuthorization)();

@interface GMLocationManager : NSObject <CLLocationManagerDelegate>

@property (nonatomic, readonly) CLLocation *location;
@property (nonatomic, assign, readonly) NSInteger statusWhenAppBackground;

/// 授权回调
@property (nonatomic, copy) GMLocationAuthorizationBlock authorBlock;

+ (instancetype)shareInstance;

/**
 *  @author wangyang, 16-03-11 17:03:21
 *
 *  @brief 定位成功的回调
 *  @since 5.9.2
 */
- (void)addBlock:(LocationFinishBlock)block;

/**
 *  @author wangyang, 16-03-11 17:03:31
 *
 *  @brief 在dealloc时需要手动移除先前添加的block
 *  @since 5.9.2
 */
- (void)removeLast;

/**
 *  @author wangyang, 16-02-24 15:02:11
 *
 *  @brief 尝试使用定位功能。如果没有权限会有提示，如果有权限直接重新定位
 *  @since 5.9.1
 */
- (void)tryLocationService;


//@property (nonatomic, copy) RequestLocationAuthorization *authorizationBlock;


/**
 保证有网络的l时候调用 不然那会失败
 */
-(void)notDeterminedShowLocationAuthorize;

/**
 尝试使用定位功能。如果没有权限会有提示，并只提示一次

 @param key 如果key不为nil，那么该key下的无权限提示只会展示一次，直到app删除。
 如果key为nil，相当于调用tryLocationService
 */
- (void)tryLocationServiceForKey:(NSString *)key;
/**
 *  @author wangyang, 16-03-10 14:03:57
 *
 *  @brief 静默的尝试重新定位，而不会有任何提示
 *  @since 5.9.2
 */
- (void)updateLocation;

/// 更新定位前先停止上次定位
- (void)stopLocationIfNeeded;

/**
 *  @author wangyang, 16-03-10 12:03:57
 *
 *  @brief 会判断是否允许定位服务
 *  @return YES表示允许
 *  @since 5.9.2
 */
+ (BOOL)hasOpenLocationService;

/**
 *  @author wangyang, 16-03-10 18:03:03
 *
 *  @brief 跳转到定位服务的系统设置页
 *  @since 5.9.2
 */
+ (void)jumpToSettings;

/**
 *  @author wangyang, 16-03-10 12:03:21
 *
 *  @brief 会判断是否允许定位服务，如果不允许会弹出alert
 *  @since 5.9.2
 */
+ (void)showAlertIfNotAllowed;
@end
