//
//  UIViewController+PushType.m
//  Gengmei
//
//  Created by Terminator on 2017/8/30.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "UIViewController+PushType.h"
#import <objc/runtime.h>
#import "GMNavigationController.h"

@implementation UIViewController (PushType)
- (UIView *)snapshot
{
    UIView *view = objc_getAssociatedObject(self, @"gmSnapshot");
    if (!view) {
        view = [self.navigationController.view snapshotViewAfterScreenUpdates:NO];
        [self setSnapshot:view];
    }
    return view;
}

- (void)setSnapshot:(UIView *)snapshot
{
    objc_setAssociatedObject(self, @"gmSnapshot", snapshot, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (BOOL)isPresent {
    return [objc_getAssociatedObject(self, @"gmIsPresent") boolValue];
}

-(void)setIsPresent:(BOOL)isPresent {
    objc_setAssociatedObject(self, @"gmIsPresent", [NSNumber numberWithBool:isPresent], OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (void)popToPresentPreviousController {
    for (int index = 0; index < self.navigationController.viewControllers.count; index++) {
        UIViewController *controller = self.navigationController.viewControllers[index];
        if (controller.isPresent) {
            GMNavigationController *nav = (GMNavigationController *)self.navigationController;
            nav.needPopPresetAnimation = YES;
            UIViewController *previewController = self.navigationController.viewControllers[index - 1];
            [controller.navigationController popToViewController:previewController animated:YES];
            return;
        }
    }
}
@end
