//
//  WMListViewModel.h
//  Gengmei
//  带列表的ViewController对于的ViewModel
//  Created by Thierry on 3/5/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "WMViewModel.h"
#import <GMNetService/WMNetService.h>

/**
 *  @brief  WMTableView协议
 */
@protocol WMFetchDataModelProtocol <NSObject>

@optional
/**
 *  @brief  构造Http请求的params的值，如果不构造，则params为nil
 */
- (void)buildParams;

/**
 *  @brief  当接口返回的数据类型为字典，将远程字典数据映射到本地模型
 *
 *  @param dic 远程获取的字典
 */
- (void)buildModelWithRemoteDic:(NSDictionary *)dic;

/**
 *  @brief  当接口返回的数据类型为数组，将远程数组数据映射到本地模型
 *
 *  @param dic 远程获取的数组
 */
- (void)buildModelWithRemoteArray:(NSArray *)array;

/**
 *  @author wangyang, 15-11-25 15:11:53
 *
 *  @brief  解析去重数组，并且添加到 self.dataArray 中
 *  @param array JSON 中的 Object 数组，也可以是转成 Model 的 array
 *  @param buildBlock 用这个把 dic 转为 Model 再返回。可以为NULL。为NULL时一般用于 array 已经是转成 Model 的 array
 *  @since 5.6.0
 */
- (void)deduplicationForArray:(NSArray *)array buildModelBlock:(id (^)(NSDictionary *dic))buildBlock;
/**
 *  @author wangyang, 16-01-14 16:01:53
 *
 *  @brief 将数组去重，然后返回组织好数据的新model数组
 *  @param array      待去重的数据
 *  @param buildBlock 解析器
 *  @return 使用解析器组织好Model的数据
 *  @since 5.8.0
 */
- (NSArray *)deduplicationArrayFromArray:(NSArray *)array buildModelBlock:(id (^)(NSDictionary *dic))buildBlock;
@end


@interface WMFetchDataViewModel : WMViewModel<WMFetchDataModelProtocol>{
    /** @brief  列表数据远程请求Url地址 */
    NSString *_remoteUrl;
    /** @brief  http远程请求的参数 */
    NSDictionary *_params;

    /**
     *  @author wangyang, 15-11-23 15:11:30
     *
     *  @brief  去重字典。保存那些已经加载过的数据的 key，value 都为 YES。详见 _deduplicationKey
     因为服务器返回的数据有可能是重复的，所以添加一个字典，新添加的数据的唯一标识放在这里，追加的数据要从这里检查，如果存在，就不添加
     *
     *  @since 5.5.0
     */
    NSMutableDictionary *_deduplicationDic;

    /**
     *  @author wangyang, 15-11-23 15:11:16
     *
     *  @brief  去重时需要用到的实体属性 key。例如帖子列表页使用 id 属性来去重，那么 _deduplicationKey = @"id"
     *  @note   默认为 nil，如果不为 nil，就会启动去重功能
     *  @since 5.5.0
     */
    NSString *_deduplicationKey;
}
@property (nonatomic,assign) HttpMethod httpMethod;

@property (nonatomic, copy) NSArray *notDeduplicate;
// 去重时被去掉的数据总计。在上拉加载更多时，这个数目仍要被用上，否则在某种极端的情况下，startNum会与服务器对不上，导致出现没有数据返回
@property (nonatomic,assign) NSInteger deleteCount;

/** @brief 记录服务器返回的字段 message 用来显示空白文案*/
@property (nonatomic, strong) NSString *message;

/** @brief 获取数据失败信息*/
@property (nonatomic,strong) NSString *fetchDataErrorMsg;
/** @brief 获取数据为空信息*/
@property (nonatomic,strong) NSString *fetchDataNilMsg;

/** @brief  获取http数据分页第一页起始位置，默认为0，下一页为startNum+每页的数据条数（默认为10） */
@property (nonatomic,assign) NSInteger startNum;

/** @brief  获取http数据，按照页码进行获取（默认为1） */
@property (nonatomic,assign) NSInteger page;

/** @brief  获取http数据，每页获取数据（默认为10） */
@property (nonatomic,assign) NSInteger count;

/** @brief  请求返回的数据，用于TableView的DataSource */
/** @brief  请求数据是否成功 */@property (nonatomic,strong) NSMutableArray *dataArray;

@property (nonatomic,strong) NSNumber *fetchDataSuccess;

/**
 *  @brief  获取远程数据
 */
- (void)fetchRemoteData;

/**
 *  @author wangyang, 15-10-07 16:10:30
 *
 *  @brief  通过重写该方法，可以控制是否要清除数据
 *  @param response server 返回的 json
 *  @return YES 表示清除
 *  @since 5.2.0
 */

- (BOOL)shouldClearDataForResponse:(id)response;

/**
 *  @brief  在确认需要刷新时如果需要做一些删除数据的操作，在这里做就可以。
 */
- (void)clearData;
/**
 *  @brief  处理下拉刷新
 */
- (void)handleHeaderRefreshing;

/**
 *  @brief  处理上拉加载更多
 */
- (void)handleFooterRereshing;


@end
