//
//  BaseViewController.m
//  Gengmei
//
//  Created by 老邢Thierry on 13-9-27. Maintain by iOS Team Member. Rewrite by 汪洋 in 2016-7-8.
//  Copyright (c) 2013年 老邢Thierry. All rights reserved.
//

#import "WMBaseViewController.h"
#import "GMBaseUtil.h"

@interface WMBaseViewController () {
}

@end

@implementation WMBaseViewController

- (instancetype)init
{
    // 在init方法里调用initWithNibName:bundle，保证了WMBaseViewController里的initWithNibName不会再次被调用，也就是保证了initController方法不会被调用两次
    self = [super initWithNibName:nil bundle:nil];
    if (self) {
        [self initController];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)coder
{
    self = [super initWithCoder:coder];
    if (self) {
        [self initController];
    }
    return self;
}

- (instancetype)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    [self initController];
    return self;
}

- (void)initController{
    self.controlNavigationByYou = NO;
    // 在 initController 中初始化自定义导航栏有很大好处。至少可以保证视图被push之前就可以访问navigationBar，以配置title等属性
    [self customNavigationBar];
    
    self.isFirst = 1;
}

- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    self.view.backgroundColor = UIColor.background;
    self.edgesForExtendedLayout = UIRectEdgeNone;
    [self addNavigationBar];
    [self hideLeftButtonForRootController];
    //保证一些网络请求需要接参数referer的时候referer是有值的
    [self initReferer];
    [self initRefererLink];
    [self initReferrerTabName];
    [self setupEmptyView];
}
- (void)setupEmptyView {
    _emptyView = [[GMEmptyView alloc] initWithFrame:CGRectZero];
    _emptyView.hidden = YES;
    _emptyView.delegate = self;
    [self.view addSubview:_emptyView];
    [_emptyView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        if ([self.parentViewController isKindOfClass:[UINavigationController class]]) {
            make.top.mas_equalTo(OCNavigationBar.statusBarHeight);
        } else {
            make.top.mas_equalTo(0);
        }
        make.bottom.mas_equalTo(0);
    }];
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];

    // 保证即使在loading的时候，仍然可以后退
    if (!self.controlNavigationByYou) {
        [self.view bringSubviewToFront:self.navigationBar];
    }
}

- (void)didMoveToParentViewController:(UIViewController *)parent {
    [super didMoveToParentViewController:parent];

    // 作为childController使用，但不是被push到 UINavigationController时，隐藏导航栏
    if (parent != nil && ![parent isKindOfClass:[UINavigationController class]]) {
        self.navigationBar.hidden = YES;
    }
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];

    // 导航栏隐藏在 viewWillAppear 里控制的原因是在viewDidLoad时，有可能 navigationController 与 self 并没有关系
    self.navigationController.navigationBarHidden = YES;
    [[Phobos sharedClient] onPVStart:self];
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [[Phobos sharedClient] onPVEnd:self];
}

- (UIStatusBarStyle)preferredStatusBarStyle{
    
    if (@available(iOS 13.0, *)) {//适配iOS13
        
        return UIStatusBarStyleDarkContent;
    } else {
        return UIStatusBarStyleDefault;
    }
}

#pragma mark - 导航
- (void)customNavigationBar {
    _navigationBar = [OCNavigationBar new];
}

- (void)addNavigationBar {
    _navigationBar.delegate = self;
    [self.view addSubview:_navigationBar];
    [_navigationBar mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(OCNavigationBar.barHeight);
    }];
}

- (void)hideLeftButtonForRootController {
    if (self.navigationController.viewControllers.count == 1) {
        _navigationBar.leftButton.hidden = YES;
    }
}

- (void)setTitle:(NSString *)title {
    [super setTitle:title];
    self.navigationBar.title = title;
}

- (void)pushViewController:(UIViewController *)controller {
    [self.navigationController pushViewController:controller animated:YES];
}

#pragma mark - OCNavigationBarDelegate
- (void)nearRightButtonClicked:(OCNavigationBarButton *)button {}
- (void)rightButtonClicked:(OCNavigationBarButton *)button {}
- (void)backAction:(OCNavigationBarButton *)button {
    if ([self.parentViewController isKindOfClass:[UINavigationController class]]) {
        UINavigationController *navigation = (UINavigationController *)self.parentViewController;
        NSArray *controllers = navigation.viewControllers;
        if (self.presentingViewController && controllers.count == 1) {
            [self dismissViewControllerAnimated:YES completion:nil];
        }else{
            [self.navigationController popViewControllerAnimated:YES];
        }
    }else{
        [self dismissViewControllerAnimated:YES completion:nil];
    }
}

#pragma mark - GMEmptyView
- (void)showEmptyView:(GMEmptyViewType)type {
    _emptyView.type = type;
    _emptyView.hidden = NO;
    [self.view bringSubviewToFront:_emptyView];
}

- (void)hideEmptyView {
    _emptyView.hidden = YES;
}

- (void)emptyViewDidClickReload {}
@end
