//
//  UIViewController+Phobos.m
//  Pods
//
//  Created by wangyang on 16/7/12.
//
//

#import "UIViewController+Phobos.h"
#import <objc/runtime.h>

@implementation UIViewController (Phobos)
/**
 *  @author 翟国钧, 16-03-01 15:03:24
 *
 *  @brief 取当前导航栈中当前VC的上级VC，如果该VC存在，就获取他的pageName
 *
 *  @return 前一页的pageName
 *
 *  @since 5.9.1
 */
- (void)setReferer:(NSString *)referer {
    NSArray *navigationPool = self.navigationController.viewControllers;
    NSInteger refererIndex = navigationPool.count - 2;
    if (refererIndex < 0 ) {
        return ;
    }
    
    UIViewController *controller = navigationPool[refererIndex];
    objc_setAssociatedObject(self, @selector(referer), controller.pageName, OBJC_ASSOCIATION_COPY);
}

- (NSString *)referer
{
    NSString *referer = objc_getAssociatedObject(self, @selector(referer));
    return referer == nil ? @"" : referer;
}

- (NSString *)pageName {
    NSString *name = objc_getAssociatedObject(self, @selector(pageName));
    return name == nil ? @"" : name;
}

- (void)setPageName:(NSString *)pageName {
    objc_setAssociatedObject(self, @selector(pageName), pageName, OBJC_ASSOCIATION_COPY);
}

- (NSString *)businessId {
    NSString *businessId = objc_getAssociatedObject(self, @selector(businessId));
    return businessId == nil ? @"" : businessId;
}

- (void)setBusinessId:(NSString *)businessId {
    objc_setAssociatedObject(self, @selector(businessId), businessId, OBJC_ASSOCIATION_COPY);
}

- (void)setInTime:(NSString *)inTime {
    objc_setAssociatedObject(self, @selector(inTime), inTime, OBJC_ASSOCIATION_COPY);
}


/**
    这个地方inTime的值为nil的情况不做考虑,因为Phobos不会发送
 */
- (NSString *)inTime {
    NSString *inTime = objc_getAssociatedObject(self, @selector(inTime));
    return inTime;
}

- (void)setReferrerId:(NSString *)referrerId {
    objc_setAssociatedObject(self, @selector(referrerId), referrerId, OBJC_ASSOCIATION_COPY);
}

- (NSString *)referrerId {
    NSString *referrerId = objc_getAssociatedObject(self, @selector(referrerId));
    return referrerId == nil ? @"" : referrerId;
}
@end
