//
//  WMTagObject.h
//  Gengmei
//
//  Created by Sean Lee on 1/21/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <GMBase/GMObject.h>
@class GMZoneTagsObject;

@protocol WMTagObject  @end

/**
 *  @brief  创建日记本时使用
 */
@interface WMTagObject : GMObject

/** @brief tag名称 name*/
@property (nonatomic, strong) NSString *name;
/** @brief tagId概念一样,服务器返回来的是int */
@property (nonatomic, assign) NSInteger tagId;
/***  @brief  是否选中 在3级选择项目页使用*/
@property (nonatomic, assign) BOOL isSelected;
@property (nonatomic, assign) BOOL freeToAdd;
@property (nonatomic, assign) BOOL isShowImg;
/** 活动标签tag, 7770 */
@property (nonatomic, assign) BOOL isActivityTags;

#pragma mark - since 7110
/** 热度分 */
@property (nonatomic, copy) NSString *hotScore;
/** 标签样式 */
@property (nonatomic, copy) NSString *style;
/** 标签对应图片 */
@property (nonatomic, copy) NSString *styleImageUrl;
/** 高亮 */
@property (nonatomic, copy) NSString *highlight;

/** 标签点击来源 */
@property (nonatomic, copy) NSString *tagSource;

@property (nonatomic,copy) NSString *isNewTag;

+ (WMTagObject *)constructionModel:(GMZoneTagsObject *)zoneObject;

@end
