//
//  GMListViewModel.h
//  Gengmei
//  带列表的ViewController对于的ViewModel
//  Created by Thierry on 3/5/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "WMViewModel.h"


/**
 加载更多时，使用start_num来作为分页标记，还是使用offset

 - GMListViewPageTypeStartNum: 请求数据时会使用start_num
 - GMListViewPageTypeOffset: 请求数据时会使用offset
 */
typedef NS_ENUM(NSUInteger, GMListViewPageType) {
    GMListViewPageTypeStartNum,
    GMListViewPageTypeOffset,
};

@interface GMListViewModel : WMViewModel {
    /** @brief  列表数据远程请求Url地址 */
    NSString *_remoteUrl;
    /** @brief  http远程请求的参数 */
    NSDictionary *_params;

    /**
     *  @author wangyang, 15-11-23 15:11:30
     *
     *  @brief  去重字典。保存那些已经加载过的数据的 key，value 都为 YES。详见 _deduplicationKey
     因为服务器返回的数据有可能是重复的，所以添加一个字典，新添加的数据的唯一标识放在这里，追加的数据要从这里检查，如果存在，就不添加
     *
     *  @since 5.5.0
     */
    NSMutableDictionary *_deduplicationDic;

    /**
     *  @author wangyang, 15-11-23 15:11:16
     *
     *  @brief  去重时需要用到的实体属性 key。例如帖子列表页使用 id 属性来去重，那么 _deduplicationKey = @"id"
     *  @note   默认为 nil，如果不为 nil，就会启动去重功能
     *  @since 5.5.0
     */
    NSString *_deduplicationKey;
}

@property (nonatomic, copy) NSArray *notDeduplicate;
// 去重时被去掉的数据总计。在上拉加载更多时，这个数目仍要被用上，否则在某种极端的情况下，startNum会与服务器对不上，导致出现没有数据返回
@property (nonatomic, assign) NSInteger deleteCount;

/** @brief 记录服务器返回的字段 message 用来显示空白文案*/
@property (nonatomic, strong) NSString *message;

/** @brief 获取数据失败信息*/
@property (nonatomic, strong) NSString *fetchDataErrorMsg;
/** @brief 获取数据为空信息*/
@property (nonatomic, strong) NSString *fetchDataNilMsg;

/** @brief  获取http数据分页第一页起始位置，默认为0，下一页为startNum+每页的数据条数（默认为10） */
@property (nonatomic, assign) NSInteger startNum;

/** @brief  请求返回的数据，用于TableView的DataSource */
@property (nonatomic, strong) NSMutableArray *dataArray;

/**
 加载更多时，使用的分页类型，默认是start_num
 */
@property (nonatomic, assign) GMListViewPageType pageType;

/**
 第一次请求数据时、下拉刷新、重新加载数据，该属性都会为YES。数据请求结束并且页面已经更新，该值为NO
 */
@property (nonatomic, assign, readonly) BOOL isRefreshing;

/**
 上拉加载更多数据时为YES
 */
@property (nonatomic, assign, readonly) BOOL isLoadingMore;

/**
 第一次请求数据时会为YES
 */
@property (nonatomic, assign, readonly) BOOL isFirstLoad;

/**
 *  @brief  获取远程数据
 */
- (void)fetchRemoteData;

/**
 *  @author wangyang, 15-10-07 16:10:30
 *
 *  @brief  通过重写该方法，可以控制是否要清除数据
 *  @param response server 返回的 json
 *  @return YES 表示清除
 *  @since 5.2.0
 */

- (BOOL)shouldClearDataForResponse:(id)response;

/**
 *  @brief  在确认需要刷新时如果需要做一些删除数据的操作，在这里做就可以。
 */
- (void)clearData;

/**
 *  @brief  处理下拉刷新
 */
- (void)handleHeaderRefreshing;

/**
 *  @brief  处理上拉加载更多
 */
- (void)handleFooterRereshing;


@end
