//
//  WMListViewModel.m
//  Gengmei
//
//  Created by Thierry on 3/5/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMListViewModel.h"
@import GMNetworking;

@implementation GMListViewModel
{
    
}
- (instancetype)init{
    self = [super init];
    if (self) {
        _remoteUrl = @"";
        _pageType = GMListViewPageTypeStartNum;
        _dataArray = [[NSMutableArray alloc] init];
        _startNum = 0;
        _params = nil;
        _deduplicationDic = [NSMutableDictionary dictionary];
        _fetchDataErrorMsg = @"获取数据失败，请重试";
        _fetchDataNilMsg = @"暂时没有相关数据";
        _message = @"";

    }
    return self;
}

/**
 *  @brief  默认列表对于的接口都会有start_num和count参数
 *          如果没有则重写此方法即可
 */
- (void)buildParams{
    _params = @{@"start_num":@(self.startNum),
                @"count":@(10)};
}

- (BOOL)shouldClearDataForResponse:(id)response{
    return self.startNum == 0;
}


/**
 TODO:
 1. 使用fetchRemoteDataComplete，在ListController中删除KVO
 2. 在complete最后改变isRefreshing等标记位
 3. 让刷新与加载更多不能同时进行
 4. 。。。
 */
- (void)fetchRemoteData {
    
    if (_remoteUrl.length == 0) {
        return;
    }
    
    // TODO: response.data 需要考虑
    [self buildParams];
    [GMNetworking requestOCWithApi:_remoteUrl method:GMHTTPMethodGet parameters:_params completion:^(GMResponseOC * response) {
        
        if ([self shouldClearDataForResponse:response.data]) {
            [self clearData];
        }
        
        if (response.isSuccess) {
            [self buildModelWithRemoteDic:response.data];
        } else {
            self.message = response.message;
        }
        
        
    }];
}


/**
 *  @author wangyang, 15-11-25 16:11:00
 *
 *  @brief  在确认需要被清除数据时才调用。刷新开始并不代码需要清除数据
 */
- (void)clearData{
    // 因为 clearData 可能会被外部调用，所以 self.startNum = 0 要确认执行，不能少
    self.startNum = 0;
    _deleteCount = 0;
    [self.dataArray removeAllObjects];
    [_deduplicationDic removeAllObjects];
}

- (void)handleHeaderRefreshing
{
    self.startNum = 0;
    [self fetchRemoteData];
}

- (void)handleFooterRereshing
{
    self.startNum = self.dataArray.count + _deleteCount;
    [self fetchRemoteData];
}

/**

 */
- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    
}

/**
 *  @brief 空方法，由子类来实现
 *
 *  @param dic  返回的数组型数据
 */
- (void)buildModelWithRemoteArray:(NSArray *)array{

}


- (void)deduplicationForArray:(NSArray *)array buildModelBlock:(id (^)(NSDictionary *dic))buildBlock{

    if (_deduplicationKey.length == 0) {
        return;
    }

    // NSMutableArray 不是线程安全的，不能使用并行枚举。参考https://developer.apple.com/library/mac/documentation/Cocoa/Conceptual/Multithreading/ThreadSafetySummary/ThreadSafetySummary.html
    [array enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        id value = [obj valueForKey:_deduplicationKey];
        NSString *key = [value isKindOfClass:[NSString class]] ? value : [value stringValue];
        NSAssert(key.length > 0, @"key 怎么会是一个空???!!!");
        if (!_deduplicationDic[key]) {
            if ([obj isKindOfClass:[NSDictionary class]]) {
                id object = buildBlock(obj);
                [self.dataArray addObject:object];
            }else{
                [self.dataArray addObject:obj];
            }
            _deduplicationDic[key] = @1;
        }else{
            _deleteCount ++;
        }
    }];
}

- (NSArray *)deduplicationArrayFromArray:(NSArray *)array buildModelBlock:(id (^)(NSDictionary *dic))buildBlock{

    if (_deduplicationKey.length == 0) {
        return @[];
    }

    NSMutableArray *result = [NSMutableArray array];

    // NSMutableArray 不是线程安全的，不能使用并行枚举。参考https://developer.apple.com/library/mac/documentation/Cocoa/Conceptual/Multithreading/ThreadSafetySummary/ThreadSafetySummary.html
    [array enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if ([self.notDeduplicate containsObject:obj[@"type"]]) {
            id object = buildBlock(obj);
            [result addObject:object];
        } else {
            id value = [obj valueForKey:_deduplicationKey];
            NSString *key = [value isKindOfClass:[NSString class]] ? value : [value stringValue];
            NSAssert(key.length > 0, @"key 怎么会是一个空???!!!");
            if (!_deduplicationDic[key]) {
                if ([obj isKindOfClass:[NSDictionary class]]) {
                    id object = buildBlock(obj);
                    [result addObject:object];
                }else{
                    [result addObject:obj];
                }
                _deduplicationDic[key] = @1;
            }else{
                self.deleteCount ++;
            }
        }
    }];

    return result;
}


@end
