//
//  WMBaseViewController+OCNavigationBar.h
//  Gengmei
//
//  Created by wangyang on 16/7/8.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//



/***  @brief  右按钮的 按钮类型 */
typedef NS_ENUM(NSUInteger, OCBarButtonImageType){

    /***  @brief  默认没有右按钮*/
    OCBarButtonImageTypeDefault = 0,
    /***  @brief  图片分享按钮 */
    OCBarButtonImageTypeShare = 1,
    /***  @brief  写新日记 */
    OCBarButtonImageTypeDiary,
    /***  @brief  搜索按钮。如果是继承于WMBaseViewController，这个option的action不需要单独实现，在base中已经实现了 */
    OCBarButtonImageTypeSearch,
    /***  @brief  分享返现，具体方法没有实现，请在子类中实现*/
    OCBarButtonImageTypeShareCashback,
    /***  @brief  客服，请在子类中实现*/
    OCBarButtonImageTypeCustomerServices,
};

@interface WMBaseViewController (OCNavigationBar)


/**
 *  @brief  设置导航栏 左边默认是返回按钮
 *
 *  @param title      导航tilte
 *  @param rightTitle 右边文字型的按钮
 */
- (void)setNavigateTitle:(NSString *)title rightButtonTitle:(NSString *)rightButtonTitle;

/**
 *  @brief  设置导航栏 左边默认是返回按钮
 *
 *  @param title       导航tilte
 *  @param rightButton 右边是图片型的按钮
 */
- (void)setNavigateTitle:(NSString *)title rightButtonOption:(OCBarButtonImageType)rightButtonOption;

/**
 *  @brief  当右侧是标题按钮时，设置右侧标题按钮不同状态下的色值
 *  @param normalColor     常态下色值
 *  @param highlightColor  高亮下色值
 *  @param disableColor    失效下色值
 */
- (void)setRightTitleNormalColor:(UIColor *)normalColor highlightColor:(UIColor *)highlightColor disableColor:(UIColor *)disableColor;

/**
 *  @author wangyang
 *
 *  通过此方法可以返回一个rightButton图片名，用于navigationBar.rightIcon
 */
- (NSString *)navigationBarIconFromType:(OCBarButtonImageType)type;
@end
