//
//  GMAdLabel.swift
//  Gengmei
//
//  Created by Terminator on 2016/12/22.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

import UIKit
//import GMBaseSwift

@objcMembers
public class GMAdLabel: GMLabel {

    var ADText = "" {
        didSet {
            adLabel.text = ADText
        }
    }
    var adLabel = GMLabel()
    var isSHowAD = false {
        didSet {
            if isSHowAD {
                adLabel.isHidden = false
            } else {
                adLabel.isHidden = true
            }
        }
    }

    required  init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }

    public var adLabelTop = 0 {
        didSet {
            adLabel.snp.remakeConstraints { (make) in
                make.left.equalTo(0)
                make.top.equalTo(adLabelTop)
            }
        }
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        adLabel.isHidden = true
        adLabel.layer.cornerRadius = 3
        adLabel.clipsToBounds = true
        adLabel.layer.borderColor = UIColor.secondaryVisual.cgColor
        adLabel.layer.borderWidth = Constant.onePixel
        adLabel.backgroundColor = UIColor.white
        adLabel.font = UIFont.gmFont(10)
        adLabel.textColor = UIColor.secondaryVisual
        // 设计图是(2, 5, 2, 5)，但是由于字体本身上下有空白，所以改为
        adLabel.paddingEdge = UIEdgeInsets(top: 1, left: 5, bottom: 1, right: 5)
        adLabel.textAlignment = .center
        addSubview(adLabel)
    }
}
