//
//  GMCalendarEventManager.swift
//  Gengmei
//
//  Created by 汪俊 on 16/7/4.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

import UIKit
//import GMBaseSwift

import EventKit
public typealias  CalendarAuthorizationAllowedBlock = () -> Void
@objcMembers
public class GMCalendarEventManager: NSObject {
    public var authorizationAllowed: CalendarAuthorizationAllowedBlock?
    public var eventStore = EKEventStore()
    public override init() {
        
        super.init()
        //请求授权
        let status = EKEventStore.authorizationStatus(for: .event)
        if status == .notDetermined {
            eventStore.requestAccess(to: .event, completion: { (allowed, _) in
                if allowed {
                    print("allowed")
                    if self.authorizationAllowed != nil {
                        self.authorizationAllowed!()
                    }
                } else {
                    print("not allowed")
                }
            })
        } else if status == .restricted || status == .denied {
            showAlertcontrolle()
        }
    }
    
    /**
     添加日历事件
     - author: wangjun 07-07-2016 in 6.1.0
     - parameter title:       事件的标题
     - parameter startDate:   开始时间
     - parameter endDate:     结束时间`
     - parameter triggerTime: 提醒事件
     - parameter url:         跳转到美购详情页面的地址
     */
    public func addEvent(_ title: String = "", startDate: TimeInterval, endDate: TimeInterval, serviceId: String, url: String) {
        let timeZone = TimeZone.current
        let deltaTime = timeZone.secondsFromGMT()
        let event = EKEvent(eventStore: eventStore)
        let gengmeiTitle = "更美App秒杀: " + title
        event.title = gengmeiTitle
        event.startDate = Date(timeIntervalSince1970: startDate - TimeInterval(deltaTime))
        event.endDate = Date(timeIntervalSince1970: endDate - TimeInterval(deltaTime))
        event.calendar = eventStore.defaultCalendarForNewEvents
        event.notes = url
        //计算出秒杀提醒时间,开始前3分钟
        var triggerTime = Date(timeIntervalSince1970: startDate)
        triggerTime = triggerTime.addingTimeInterval(-180 - TimeInterval(deltaTime))
        let alarm = EKAlarm(absoluteDate: triggerTime)
        event.addAlarm(alarm)
        do {
            try eventStore.save(event, span: .thisEvent)
            //将event的id 保存到本地
            UserDefaults.standard.set(event.eventIdentifier, forKey: serviceId)
            UserDefaults.standard.synchronize()
        } catch {
            print("error show")
        }
    }
    
    /**
     通过标题删除日历事件
     - author: wangjun 07-07-2016 in 6.1.0
     - parameter title: 事件的标题
     */
    public func removeEvent(_ serviceId: String) {
        
        //取出对应的event eventId
        guard let eventId = (UserDefaults.standard.object(forKey: serviceId)) as? String else {
            return
        }
        let event = eventStore.event(withIdentifier: eventId)
        do {
            if event != nil {
                try eventStore.remove(event!, span: .thisEvent)
            }
        } catch {
            print("error")
        }
    }
    
    /**
     判断用户是够开启日历服务
     - author: wangjun
     - date: 16-07-04 18:07:22 07-04-2016 in 6.1.0
     */
    public func checkAuthorized() -> Bool {
        return EKEventStore.authorizationStatus(for: .event) == .authorized
    }
    
    /**
     提醒用户开启日历服务的alert
     - author: wangjun 07-07-2016 in 6.1.0
     */
    public func showAlertcontrolle() {
        
        let status = EKEventStore.authorizationStatus(for: .event)
        if status == .authorized {
            return
        } else {
            let alert = UIAlertController(title: "", message: "未授权日历权限,可能导致无法成功提醒哟,快去开启设置吧", preferredStyle: .alert)
            let actionA = UIAlertAction(title: "取消", style: .cancel) { (_) in}
            alert.addAction(actionA)
            let actionB = UIAlertAction(title: "去设置", style: .default) { (_) in
                if #available(iOS 10.0, *) {
                    UIApplication.shared.open(URL(string: UIApplication.openSettingsURLString)!, options: [:], completionHandler: nil)
                } else {
                    UIApplication.shared.openURL(URL(string: UIApplication.openSettingsURLString)!)
                }
            }
            alert.addAction(actionB)
            GMBaseTool.getCurrentViewController().present(alert, animated: true, completion: nil)
        }
    }
}
