//
//  GMClientH5Object.m
//  Gengmei
//
//  Created by wangyang on 7/25/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMClientH5Object.h"
#import <GMFoundation/GMFoundation-umbrella.h>
//#import "GMLaunchManager.h"
#import "GMBaseWebViewController.h"

/**
 *  @author licong, 15-12-25 15:12:44
 *
 *  JSCore引擎调用OC做UI渲染操作，必须保证是在主线程执行，所以都加了 dispatch_async 以保证主线程工作
 *
 */
@implementation GMClientH5Object

- (void)jsObjShowShareView:(NSString *)JSONstring{
    if ([self.delegate respondsToSelector:@selector(jsObjShowShareViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsObjShowShareViewWithJSONString:JSONstring];
        });
    }
}

- (void)jsObjShowDiaryShareView:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsObjShowDiaryShareViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsObjShowDiaryShareViewWithJSONString:JSONString];
        });
    }
}

- (void)showWXShareView:(NSString *)JSONstring{
    if ([self.delegate respondsToSelector:@selector(jsShowWXShareViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowWXShareViewWithJSONString:JSONstring];
        });
    }
}


- (void)jsPop:(BOOL)animated{
    if ([self.delegate respondsToSelector:@selector(jsPopViewControllerAnimated:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsPopViewControllerAnimated:animated];
        });
    }
}

//TODO: 待修改
- (NSString *)domain{
    return @"";
//    return APIHOST;
}

- (void)showLoading{
    if ([self.delegate respondsToSelector:@selector(jsShowLoading)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowLoading];
        });
    }
}

- (void)hideLoading{
    if ([self.delegate respondsToSelector:@selector(jsHideLoading)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsHideLoading];
        });
    }
}

- (void)showAlert:(NSString *)JSONString{
    if ([self.delegate respondsToSelector:@selector(jsShowAlertViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowAlertViewWithJSONString:JSONString];
        });
    }
}

- (void)showConfirm:(NSString *)JSONString{
    if ([self.delegate respondsToSelector:@selector(jsShowConfirmViewWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowConfirmViewWithJSONString:JSONString];
        });
    }
}

- (void)showToast:(NSString *)JSONString{
    if ([self.delegate respondsToSelector:@selector(jsShowToastWithJSONString:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowToastWithJSONString:JSONString];
        });
    }
}

- (void)trackEvent:(NSString *)JSONString {
    dispatch_async(dispatch_get_main_queue(), ^{
        if ([self.delegate respondsToSelector:@selector(jsTrackEvent:)]) {
            [self.delegate jsTrackEvent:JSONString];
        }
    });
}

- (void)playVideo:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsPlayVideo:)]) {
        [self.delegate jsPlayVideo:JSONString];
    }
}

- (void)getAddressBook {
    if ([self.delegate respondsToSelector:@selector(jsGetAddressBook)]) {
        [self.delegate jsGetAddressBook];
    }
}

- (BOOL)isLocationEnable {
    if ([self.delegate respondsToSelector:@selector(jsIsLocationEnable)]) {
       return [self.delegate jsIsLocationEnable];
    } else {
        return NO;
    }
}

- (void)chooseOneContactPerson:(NSString *)key {
    if ([self.delegate respondsToSelector:@selector(jsChooseOneContactPerson:)]) {
        [self.delegate jsChooseOneContactPerson:key];
    }
}

- (void)logout {
    if ([self.delegate respondsToSelector:@selector(jsLogout)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsLogout];
        });
    }
}

- (void)share:(NSString *)shareDataString withType:(NSString *)type{
    if ([self.delegate respondsToSelector:@selector(jsShare:withType:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShare:shareDataString withType:type];

        });
    }
}

- (void)openBrowser:(NSString *)url{
    if ([self.delegate respondsToSelector:@selector(jsOpenBrowser:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsOpenBrowser:url];
        });
    }
}

- (void)jumpToLocationSettings {
    if ([self.delegate respondsToSelector:@selector(jsJumpToLocationSettings)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsJumpToLocationSettings];
        });
    }
}

- (void)locationShowAlertIfNotAllowed {
    if ([self.delegate respondsToSelector:@selector(jsLocationShowAlertIfNotAllowed)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsLocationShowAlertIfNotAllowed];
        });
    }
}

- (void)diaryDetailShowNotificationAlert {
    if ([self.delegate respondsToSelector:@selector(jsDiaryDetailShowNotificationAlert)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsDiaryDetailShowNotificationAlert];
        });
    }
}

- (void)remindEvent:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsRemindEvent:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsRemindEvent:jsonString];
        });
    }
}

- (void)insurancePurchase:(BOOL)hasBought {
    if ([self.delegate respondsToSelector:@selector(jsInsurancePurchase:)]) {
        NSDictionary *dict = @{@"has_bought": @(hasBought)};
        [self.delegate jsInsurancePurchase:dict];
    }
}

- (void)callPhone:(NSString *)phone {
    if ([self.delegate respondsToSelector:@selector(jsCallPhone:)]) {
        [self.delegate jsCallPhone:phone];
    }
}



- (void)sendMessage:(NSString *)phone withBody:(NSString *)body {
    if ([self.delegate respondsToSelector: @selector(jsSendMessage:withBody:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSendMessage:phone withBody:body];
        });
    }
}

- (void)setHeaderHeight:(NSInteger)height {
    if ([self.delegate respondsToSelector: @selector(jsSetHeaderHeight:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSetHeaderHeight:height];
        });
    }
}

- (void)setLocalStorage:(NSString *)key WithBody:(NSString *)value {
    if ([self.delegate respondsToSelector: @selector(jsSetLocalStorage:withStorage:)]) {
        [self.delegate jsSetLocalStorage:key withStorage:value];
    }
}

- (NSString *)getLocalStorage:(NSString *)key {
    if ([self.delegate respondsToSelector: @selector(jsGetLocalStorage:)]) {
        return [self.delegate jsGetLocalStorage:key];
    } else {
        return @"";
    }
}

- (void)syncSSOInfo:(NSString *)info {
    if ([self.delegate respondsToSelector:@selector(jsSyncSSOInfo:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSyncSSOInfo:info];
        });
    }
}
//场景化弹窗
- (void)showTaskAlert:(NSString *)extra {
    if ([self.delegate respondsToSelector:@selector(jsShowTaskAlert:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowTaskAlert:extra];
        });
    }
}

- (void)newbieCouponGot:(NSInteger)flag {
    if ([self.delegate respondsToSelector:@selector(jsNewbieCouponGot:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsNewbieCouponGot:flag];
        });
    }
}

- (void)clipboard:(NSString *)boardText {
    if ([self.delegate respondsToSelector:@selector(jsClipboard:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsClipboard:boardText];
        });
    }
}

- (void)showActionSheet:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsShowActionSheet:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowActionSheet:jsonString];
        });
    }
    
}

- (void)showNativeEmptyView {
    if ([self.delegate respondsToSelector:@selector(jsShowNativeEmptyView)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowNativeEmptyView];
        });
    }
}

- (void)rightbuttonCallBack:(NSString *)json {
    if ([self.delegate respondsToSelector:@selector(jsRightbuttonCallBack:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsRightbuttonCallBack:json];
        });
    }
}

- (void)globalDataLoaded:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsGlobalDataLoaded:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsGlobalDataLoaded:jsonString];
        });
    }
}

- (int)isUserLogin {
    if ([self.delegate respondsToSelector: @selector(jsIsUserLogin)]) {
        return [self.delegate jsIsUserLogin];
    } else {
        return 0;
    }
}

- (NSString *)inflateUserInfo {
    if ([self.delegate respondsToSelector: @selector(jsInflateUserInfo)]) {
        return [self.delegate jsInflateUserInfo];
    } else {
        return @"";
    }
}

- (void)controlTitleBarVisible:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsControlTitleBarVisible:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsControlTitleBarVisible:jsonString];
        });
    }
}

- (void)answerData:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsAnswerData:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsAnswerData:jsonString];
        });
    }
}

- (void)questionData:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsQuestionData:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsQuestionData:jsonString];
        });
    }
}

- (int)navigationbarHeight {
    if ([self.delegate respondsToSelector:@selector(jsNavigationbarHeight)]) {
        return [self.delegate jsNavigationbarHeight];
    } else {
        return 0;
    }
}

- (void)checkAuthority:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsCheckAuthority:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsCheckAuthority:jsonString];
        });
    }
}

/**
 网络状态 2： 其他 1:wifi 0:无网络
 */
- (NSInteger)checkNetworkState {
    if ([self.delegate respondsToSelector:@selector(jsCheckNetworkState)]) {
        return [self.delegate jsCheckNetworkState];
    } else {
        return 0;
    }
}

//#warning TODO 
- (NSString *)nativeDataLoaded {
    if ([self.delegate isKindOfClass:[GMBaseWebViewController class]]) {
        //如果是GMBaseWebViewController 会与v7.23.0因此这样写 webCompent.webView evaluateJavaScript
        NSString *str;
       if ([self.delegate respondsToSelector:@selector(jsNativeDataLoaded)]) {
           str = [self.delegate jsNativeDataLoaded];
        } else {
           str =  @"";
        }
        return str;
    } else {
        __block NSString *str;
        dispatch_semaphore_t sem = dispatch_semaphore_create(1);
         dispatch_async(dispatch_get_main_queue(), ^{
             if ([self.delegate respondsToSelector:@selector(jsNativeDataLoaded)]) {
                str = [self.delegate jsNativeDataLoaded];
             } else {
                str =  @"";
             }
             dispatch_semaphore_signal(sem);
         });
         dispatch_semaphore_wait(sem, DISPATCH_TIME_FOREVER);
    
        return str;
    }
}



- (void)signNeverNotify {
    if ([self.delegate respondsToSelector:@selector(jsSignNeverNotify)]) {
        return [self.delegate jsSignNeverNotify];
    }
}

- (void)skipToThirdApp:(NSString *)jsonString {
    if ([self.delegate respondsToSelector:@selector(jsSkipToThirdApp:)]) {
      [self.delegate jsSkipToThirdApp:jsonString];
    }
}

/// 调起指定分享平台
/// @param JSONString {"share_data":{},"type":"Wechat"}
- (void)sharewithType:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsSharewithType:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSharewithType:[NSDictionary dictionaryWithJsonString:JSONString]];
        });
    }
}

/// 更新页面上导航数据
/// @param JSONString @param JSONString {"title":"","business_id":""}
- (void)scrollSetHeader:(NSString *)JSONString {
    
    if ([self.delegate respondsToSelector:@selector(jsScrollSetHeader:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsScrollSetHeader:[NSDictionary dictionaryWithJsonString:JSONString]];
        });
    }
}


/// 弹出评论列表+评论回复页面
/// @param JSONString JSONString
- (void)showCommentList:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsShowCommentList:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowCommentList:[NSDictionary dictionaryWithJsonString:JSONString]];
        });
    }
}

/// 弹出回答输入框
/// @param data @param JSONString
- (void)showAnswerInput:(NSString *)JSONString  {
    if ([self.delegate respondsToSelector:@selector(jsShowAnswerInput:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowAnswerInput:[NSDictionary dictionaryWithJsonString:JSONString]];
        });
    }
}

/// 跳转下一个启动项页面
//TODO: - 待修改
- (void)jumpNextLaunchPage {
    dispatch_async(dispatch_get_main_queue(), ^{
//        [[GMLaunchManager shareManager] jumpToNextLaunchPage];
    });
}

- (void)jumpToResearchPage:(NSString *)url {
    if ([self.delegate respondsToSelector:@selector(jsJumpToResearchPage:)]) {
      [self.delegate jsJumpToResearchPage:url];
    }
}

- (void)hybridExposure:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsHybridExposure:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsHybridExposure:JSONString];
        });
    }
}

- (void)saveImage:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsSaveImage:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsSaveImage:JSONString];
        });
    }
}

/// 查看今日运势( isSaveSocial： 是否保存到社区)
/// @param data @param JSONString {"isSaveSocial":"1"}
- (void)showToDayLuck:(NSString *)JSONString {
    if ([self.delegate respondsToSelector:@selector(jsShowToDayLuck:)]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self.delegate jsShowToDayLuck:[NSDictionary dictionaryWithJsonString:JSONString]];
        });
    }
}

@end

