//
//  WMBaseViewController+OCNavigationBar.m
//  Gengmei
//
//  Created by wangyang on 16/7/8.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//
#import "WMBaseViewController.h"

#import "WMBaseViewController+OCNavigationBar.h"
@implementation WMBaseViewController (OCNavigationBar)

- (void)setNavigateTitle:(NSString *)title rightButtonTitle:(NSString *)rightButtonTitle{
    self.navigationBar.title = title;
    self.navigationBar.rightTitle = rightButtonTitle;
}

- (void)setNavigateTitle:(NSString *)title rightButtonOption:(OCBarButtonImageType)rightButtonOption{
    self.navigationBar.title = title;
    self.navigationBar.rightIcon = [self navigationBarIconFromType:rightButtonOption];
}

- (NSString *)navigationBarIconFromType:(OCBarButtonImageType)type {
    switch (type) {
        case OCBarButtonImageTypeShare:
            return @"share";
        case OCBarButtonImageTypeDiary:
            return @"write";
        case OCBarButtonImageTypeSearch:
            return @"search_green";
        case OCBarButtonImageTypeShareCashback:
            return @"share_cashback";
        case OCBarButtonImageTypeCustomerServices:
            return @"customer_service";
        default:
            return @"";
    }
}

- (void)setRightTitleNormalColor:(UIColor *)normalColor highlightColor:(UIColor *)highlightColor disableColor:(UIColor *)disableColor{
    if (normalColor) {
        [self.navigationBar.rightButton setTitleColor:normalColor forState:UIControlStateNormal];
    }
    if (highlightColor) {
        [self.navigationBar.rightButton setTitleColor:normalColor forState:UIControlStateHighlighted];
    }
    if (disableColor) {
        [self.navigationBar.rightButton setTitleColor:normalColor forState:UIControlStateDisabled];
    }
}

@end
