//
//  GMLiveWelfareView.m
//  Gengmei
//
//  Created by 汪俊 on 2017/3/30.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMLiveWelfareView.h"
#import "UIView+Layout.h"
#import <GMBase/GMBase-Swift.h>
//#import "GMAdLabel.h"
#import <GMKit/GMKit-umbrella.h>
//#import "AllLayoutButton.swift"

@interface GMLiveWelfareView ()
@property (nonatomic , strong) AllLayoutButton *rightButton;
@property (nonatomic , strong) GMLabel *leftLabel;
@end

@implementation GMLiveWelfareView

- (void)setup {
    [super setup];
    __weak typeof(self)weakSelf = self;
    [self setTapActionWithBlock:^{
        [weakSelf welfareItemDidClicked];
    }];
    self.backgroundColor = UIColor.whiteColor;
    _leftLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:16];
    _leftLabel.text = @"相关美购";
    [self addSubview:_leftLabel];
    [_leftLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(14);
    }];
    
    
    _hospitalBg = [[UIImageView alloc]initWithImage:[UIImage imageNamed:@"live_hospital_bg"]];
    _hospitalBg.userInteractionEnabled = YES;
    [self addSubview:_hospitalBg];
    [_hospitalBg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(4.5);
        make.size.mas_equalTo(CGSizeMake(102, 33));
    }];

    _rightButton = [[AllLayoutButton alloc] initWithImage:[UIImage imageNamed:@"live_hospital_arrow"] title:@"医生主页" titleColor:UIColor.whiteColor font:[UIFont gmFont:15]];
    _rightButton.space = 6;
    _rightButton.type = ImageTitleTypeImageRightTitleLeft;
    _rightButton.enableAdaptive = YES;
    _rightButton.margin = UIEdgeInsetsMake(0, 18, 0, 0);
    [_rightButton addTarget:self action:@selector(hospitalDetailAction:) forControlEvents:UIControlEventTouchUpInside];
    [_hospitalBg addSubview:_rightButton];
    [_rightButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.centerY.mas_equalTo(_hospitalBg);
    }];
    
    [self addHorizontalLineWithTop:42 left:0 right:0];
    
    _welfareContainer = [[GMView alloc] init];
//    _welfareContainer.backgroundColor = [UIColor redColor];
    [self addSubview:_welfareContainer];
    [_welfareContainer mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(42);
        make.left.right.mas_equalTo(0);
        if (UIDevice.aspectRatioType == GMDeviceAspectRatioTypeWide){
            make.bottom.mas_equalTo(-18);
        } else{
            make.bottom.mas_equalTo(0);
        }
    }];
    
    _bigIconImage = [[GMImageView alloc] init];
    _bigIconImage.layer.cornerRadius = 2.5;
    _bigIconImage.layer.masksToBounds = YES;
    _bigIconImage.backgroundColor = UIColor.background;
    [_welfareContainer addSubview:_bigIconImage];
    
    _surplusBG = [[UIView alloc] init];
    _surplusBG.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.7];
    [_bigIconImage addSubview:_surplusBG];
    
    _statusBG = [[GMView alloc] init];
    [_bigIconImage addSubview:_statusBG];
    
    _surplusLabel = [GMLabel labelWithTextColor:UIColor.whiteColor fontSize:10];
    _surplusLabel.textColor = [UIColor whiteColor];
    _surplusLabel.font = [UIFont gmFont:10];
    [_statusBG addSubview:_surplusLabel];
    
    _welfareContent = [[GMAdLabel alloc] init];//[GMAdLabel labelWithTextColor:UIColor.headlineText fontSize:14];
    _welfareContent.textColor = UIColor.headlineText;
    _welfareContent.font = [UIFont gmFont:14];
    _welfareContent.numberOfLines = 2;
    _welfareContent.adLabelTop = 4;
    [_welfareContainer addSubview:_welfareContent];
    
    _doctorLabel =[[GMLabel alloc] init];
    _doctorLabel.textAlignment = NSTextAlignmentLeft;
    _doctorLabel.verticalAlignment = GMLabelVerticalAlignmentMiddle;
    _doctorLabel.font = [UIFont gmFont:12];
    _doctorLabel.textColor = UIColor.auxiliaryTextLight;
    [_welfareContainer addSubview:_doctorLabel];
    
    _hospitalLabel =[[GMLabel alloc] init];
    _hospitalLabel.textAlignment = NSTextAlignmentLeft;
    _hospitalLabel.verticalAlignment = GMLabelVerticalAlignmentMiddle;
    _hospitalLabel.font = [UIFont gmFont:12];
    _hospitalLabel.textColor = UIColor.auxiliaryTextLight;
    [_welfareContainer addSubview:_hospitalLabel];
    
    [_doctorLabel setContentHuggingPriority:252 forAxis:UILayoutConstraintAxisHorizontal];
    [_doctorLabel setContentCompressionResistancePriority:751 forAxis:UILayoutConstraintAxisHorizontal];
    [_hospitalLabel setContentHuggingPriority:251 forAxis:UILayoutConstraintAxisHorizontal];
    [_hospitalLabel setContentCompressionResistancePriority:750 forAxis:UILayoutConstraintAxisHorizontal];
    
    _seckillIcon = [[GMImageView alloc]initWithImage:[UIImage imageNamed:@"seckill_shop"]];
    [_welfareContainer addSubview:_seckillIcon];
    
    _gengmeiPrice = [GMLabel labelWithTextColor:UIColor.secondaryVisual fontSize:15];
    [_welfareContainer addSubview:_gengmeiPrice];
    _gengmeiPrice.font = [UIFont gmFont:15];
    _yuanLabel = [GMLabel labelWithTextColor:UIColor.secondaryVisual fontSize:11];
    [_welfareContainer addSubview:_yuanLabel];
    
    _marketPrice = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:9];
    [_welfareContainer addSubview:_marketPrice];
    
    _deleteLabel = [GMLabel new];
    _deleteLabel.backgroundColor = UIColor.auxiliaryTextLight;
    [_marketPrice addSubview:_deleteLabel];
    
    _applyNumber = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:11];
    [_welfareContainer addSubview:_applyNumber];
//
//    _installmentView = [[GMInstallmentView alloc] init];
//    _installmentView.layer.masksToBounds = YES;
//    [_welfareContainer addSubview:_installmentView];
//
//    _insuranceView = [[GMInsuranceView alloc] init];
//    _insuranceView.layer.masksToBounds = YES;
//    [_welfareContainer addSubview:_insuranceView];
}

- (void)updateConstraints {
    [_bigIconImage mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(15);
        make.size.mas_equalTo(CGSizeMake(100, 100));
    }];
    
    [_statusBG mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.bottom.equalTo(_bigIconImage.mas_bottom).offset(-8);
    }];
    
    [_surplusLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(5);
        make.right.mas_equalTo(-5);
        make.top.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];
    [_doctorLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_bigIconImage.mas_right).offset(15);
        make.top.equalTo(_welfareContent.mas_bottom).offset(5);
    }];
    [_hospitalLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_doctorLabel.mas_right).offset(10);
        make.right.mas_equalTo(-10);
        make.top.equalTo(_doctorLabel.mas_top);
    }];
    [_seckillIcon mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_bigIconImage.mas_right).offset(15);
        make.centerY.equalTo(_gengmeiPrice.mas_centerY);
        make.size.sizeOffset(CGSizeMake(25, 13));
    }];
    [_deleteLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.height.mas_equalTo(0.5);
        make.centerY.equalTo(_marketPrice.mas_centerY).offset(0);
        make.width.mas_equalTo(_marketPrice.mas_width);
    }];
    [_applyNumber mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-10);
        make.centerY.equalTo(_gengmeiPrice.mas_centerY);
    }];
    
    [_yuanLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_gengmeiPrice.mas_right).offset(2);
        make.bottom.equalTo(_bigIconImage.mas_bottom).offset(0);
    }];
    
//    [_installmentView mas_remakeConstraints:^(MASConstraintMaker *make) {
//        make.top.equalTo(_bigIconImage.mas_bottom).offset(15);
//        make.left.right.mas_equalTo(0);
//        make.height.mas_equalTo(35);
//    }];
    
//    [_insuranceView mas_remakeConstraints:^(MASConstraintMaker *make) {
//        make.top.equalTo(_installmentView.mas_bottom).offset(0);
//        make.left.right.mas_equalTo(0);
//        make.height.mas_equalTo(35);
//    }];
    [_marketPrice mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_yuanLabel.hidden?_gengmeiPrice.mas_right:_yuanLabel.mas_right).offset(5);
        make.bottom.equalTo(_bigIconImage.mas_bottom).offset(0);
    }];
    
    [_gengmeiPrice mas_remakeConstraints:^(MASConstraintMaker *make) {
        if (_isSeckillHidden) {
            make.left.equalTo(_bigIconImage.mas_right).offset(15);
        }else{
            make.left.equalTo(_seckillIcon.mas_right).offset(5);
        }
        make.bottom.mas_equalTo(_bigIconImage.mas_bottom).offset(2);
    }];
    
    [_welfareContent mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(10);
        if (_showPromotion) {
            make.left.equalTo(_bigIconImage.mas_right).offset(20);
        } else {
            make.left.equalTo(_bigIconImage.mas_right).offset(15);
        }
        make.right.mas_equalTo(-15);
    }];
    
//    [_installmentView mas_remakeConstraints:^(MASConstraintMaker *make) {
//        make.top.equalTo(_bigIconImage.mas_bottom).offset(15);
//        make.left.right.mas_equalTo(0);
//        if (_showInstallment) {
//            make.height.mas_equalTo(35);
//        } else {
//            make.height.mas_equalTo(0);
//        }
//    }];
//    
//    [_insuranceView mas_remakeConstraints:^(MASConstraintMaker *make) {
//        make.top.equalTo(_installmentView.mas_bottom).offset(0);
//        make.left.right.mas_equalTo(0);
//        if (_showInsurance) {
//            make.height.mas_equalTo(35);
//        } else {
//            make.height.mas_equalTo(0);
//        }
//    }];
    [super updateConstraints];
}

- (void)show {
    self.hidden = NO;
    [self mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo( MAINSCREEN_HEIGHT - self.height);
    }];
    [UIView animateWithDuration:0.25 animations:^{
        [self.superview layoutIfNeeded];
    }];
}

- (void)hide {
    [self mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(MAINSCREEN_HEIGHT);
    }];
    [UIView animateWithDuration:0.25 animations:^{
       
        [self.superview layoutIfNeeded];
    } completion:^(BOOL finished) {
        self.hidden = YES;
    }];
}

- (void)welfareItemDidClicked {
    if ([self.delegate respondsToSelector:@selector(didSelectedWelfareView:)]) {
        [self.delegate didSelectedWelfareView:self];
    }
}

- (void)hospitalDetailAction:(AllLayoutButton *)button {
    if ([self.delegate respondsToSelector:@selector(didClickedHospitalDetailButton:)]) {
        [self.delegate didClickedHospitalDetailButton:button];
    }
}

@end
