//
//  GMInstallmentView.m
//  Gengmei
//
//  Created by Terminator on 16/10/23.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMInstallmentView.h"
#import <GMKit/GMFont.h>
#import <GMKit/UIColor+GMTheme.h>
#import <GMKit/UIView+LineWithAutolayout.h>
@interface GMInstallmentView()
@property (nonatomic, strong) GMView *installView;
@end

@implementation GMInstallmentView

- (void)setup {
    [super setup];
    
    _installView = [[GMView alloc] init];
    [_installView addTopLineWithLeft:15 right:-15];
    [self addSubview:_installView];
    [_installView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(0);
        make.height.mas_equalTo(45);
    }];
    
    _icon = [[GMImageView alloc] init];
    _icon.image = [UIImage imageNamed:@"installment_icon"];
    [_installView addSubview:_icon];
    [_icon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.centerY.mas_equalTo(0);
    }];
    
    _promoteLabel = [[GMHighlightLabel alloc] init];
    [_promoteLabel setContentHuggingPriority:100 forAxis:UILayoutConstraintAxisHorizontal];
    [_promoteLabel setContentCompressionResistancePriority:1000 forAxis:UILayoutConstraintAxisHorizontal];
    _promoteLabel.hightlightColor = UIColor.secondaryVisual;
    _promoteLabel.normalColor = UIColor.bodyText ;
    _promoteLabel.textColor = UIColor.bodyText;
    _promoteLabel.font = [UIFont gmFont:11];
    _promoteLabel.hightlightFont = [UIFont gmBoldFont:11];
    [_installView addSubview:_promoteLabel];
    [_promoteLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_icon.mas_right).offset(10);
        make.right.mas_lessThanOrEqualTo(-15);
        make.centerY.equalTo(_icon.mas_centerY);
    }];
}

@end
