//
//  UIViewController+NavigationCompletionBlock.h
//  GMBase
//
//  Created by wangyang on 2018/1/25.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
@interface UIViewController (NavigationCompletionBlock)
- (void)pushViewController:(UIViewController* _Nonnull)viewController
                  animated:(BOOL)animated
                completion:(void (^ __nullable)(void))completion;

- (nullable UIViewController *)popViewControllerAnimated:(BOOL)animated
                                              completion:(void (^ __nullable)(void))completion;

- (nullable NSArray<__kindof UIViewController *> *)popToViewController:(UIViewController * _Nonnull)viewController
                                                              animated:(BOOL)animated
                                                            completion: (void (^ __nullable)(void))completion;

- (nullable NSArray<__kindof UIViewController *> *)popToRootViewControllerAnimated:(BOOL)animated
                                                                        completion: (void (^ __nullable)(void))completion;


- (void)pushAndKillToRoot:(UIViewController *)controller NS_SWIFT_NAME(pushAndKillToRoot(_:));

/**
 push动画完成后删除navigation中controller与controllerClass之间的controllers，
 然后再从controllerClass往前删除count个，包含controllerClass
 注意：controllerClass如果有多个只使用离controller最近那个
 */
- (void)push:(UIViewController *)controller andKillTo:(Class)controllerClass further:(NSInteger)count;
@end
NS_ASSUME_NONNULL_END
