//
//  GMNavigationController.m
//  Gengmei
//
//  Created by Terminator on 2017/8/30.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMNavigationController.h"
#import "UIViewController+PushType.h"
#import "GMPresentAnimation.h"
@import GMKit;
@interface GMNavigationController ()<UINavigationControllerDelegate>

@end

@implementation GMNavigationController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.delegate = self;
    self.fd_viewControllerBasedNavigationBarAppearanceEnabled = NO;
}

- (nullable id <UIViewControllerAnimatedTransitioning>)navigationController:(UINavigationController *)navigationController
                                            animationControllerForOperation:(UINavigationControllerOperation)operation
                                                         fromViewController:(UIViewController *)fromVC
                                                           toViewController:(UIViewController *)toVC {

    if (operation == UINavigationControllerOperationPush && toVC.isPresent) {
        GMPresentAnimation *animation = [[GMPresentAnimation alloc] init];
        animation.transitionType =  operation;
        return animation;
    } else if (operation == UINavigationControllerOperationPop && (fromVC.isPresent || self.needPopPresetAnimation)) {
        _needPopPresetAnimation = NO;
        GMPresentAnimation *animation = [[GMPresentAnimation alloc] init];
        animation.transitionType =  operation;
        return animation;
    }
    
    return nil;

}
@end
