//
//  UIViewController+NavigationCompletionBlock.m
//  GMBase
//
//  Created by wangyang on 2018/1/25.
//

#import "UIViewController+NavigationCompletionBlock.h"

@implementation UIViewController (NavigationCompletionBlock)
- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated completion: (void (^ __nullable)(void))completion {
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    [self.navigationController pushViewController:viewController animated:animated];
    [CATransaction commit];
}

- (nullable UIViewController *)popViewControllerAnimated:(BOOL)animated completion: (void (^ __nullable)(void))completion {
    UIViewController *poppedViewController;
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    poppedViewController = [self.navigationController popViewControllerAnimated:animated];
    [CATransaction commit];
    return poppedViewController;
}

- (nullable NSArray<__kindof UIViewController *> *)popToViewController:(UIViewController * _Nonnull)viewController animated:(BOOL)animated  completion: (void (^ __nullable)(void))completion{
    NSArray<UIViewController*>* viewControllers;
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    viewControllers = [self.navigationController popToViewController:viewController animated:animated];
    [CATransaction commit];
    return viewControllers;
}

- (nullable NSArray<__kindof UIViewController *> *)popToRootViewControllerAnimated:(BOOL)animated   completion: (void (^ __nullable)(void))completion {
    NSArray<UIViewController*>* viewControllers;
    [CATransaction setCompletionBlock:completion];
    [CATransaction begin];
    viewControllers = [self.navigationController popToRootViewControllerAnimated:animated];
    [CATransaction commit];
    return viewControllers;
}

- (void)pushAndKillToRoot:(UIViewController *)controller {
    NSMutableArray *result = [self.navigationController.viewControllers mutableCopy];
    do {
        [result removeLastObject];
    } while (result.count != 1);

    [CATransaction setCompletionBlock:^{
        [result addObject:controller];
        self.navigationController.viewControllers = result;
    }];
    [CATransaction begin];
    [self.navigationController pushViewController:controller animated:YES];
    [CATransaction commit];
}

/**
 push动画完成后删除navigation中controller与controllerClass之间的controllers。
 注意：controllerClass如果有多个只使用离controller最近那个
 */
- (void)push:(UIViewController *)controller andKillTo:(Class)controllerClass {

    NSMutableArray *result = [self.navigationController.viewControllers mutableCopy];
    do {
        [result removeLastObject];
    } while (![result.lastObject isMemberOfClass:controllerClass]);

    [CATransaction setCompletionBlock:^{
        [result addObject:controller];
        self.navigationController.viewControllers = result;
    }];
    [CATransaction begin];
    [self.navigationController pushViewController:controller animated:YES];
    [CATransaction commit];
}

@end
