//
//  WMBaseListViewController.h
//  Gengmei
//
//  Created by Thierry on 3/5/15. Maintain by iOS Team Member.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "WMBaseViewController.h"
#import <UITableView_FDTemplateLayoutCell/UITableView+FDTemplateLayoutCell.h>
#import "GMListViewModel.h"

@interface WMBaseListViewController : WMBaseViewController <UITableViewDelegate, UITableViewDataSource, GMListViewModel, UIScrollViewDelegate>
{

    UITableView *_table;
    
    /** @brief  TableView Style */
    NSInteger _tableStyle;
    
    /**  @brief  cell标示符。推荐使用Cell 的class注册*/
    NSString *_cellIdentifier;

    /** @brief  Cell行高。等同于设置了table.rowHeight */
    NSInteger _cellHeight;
    
    /**  @brief  是否需要下拉刷新 */
    BOOL _needHeaderRefresh;
    
    /**  @brief  是否需要上拉刷新 */
    BOOL _needFooterRefresh;
}

/** @brief  viewModel*/
@property (nonatomic, strong) id<GMListViewModel> viewModel;
@property (nonatomic, strong) UITableView *table;


/** @brief 控制当前VC的viewmodel是不是立即请求网络 **/
@property (nonatomic , assign) BOOL immediateLoad;


- (void)configDataForCell:(id)cell atIndexPath:(NSIndexPath *)indexPath;

/**
 *  @brief  扩展方法，用于更新除了tableview外其它UI数据. 必须call super
 */
- (void)updateOtherUIData __attribute__((objc_requires_super));

/**
 *  @brief  会先清空数据，table reloadData，再调用viewModel的fetchRemoteData
 */
- (void)refreshList;

/**
 *  @author wangyang, 15-11-30 15:11:58
 *
 *  @brief  显示 loading，并且执行 [viewModel fetchRemoteData]
 *  @since 5.5.0
 */
- (void)loadRemoteData;
/**
 *  @brief  添加KVO监听
 */
- (void)addKVO;
- (void)removeKVO;
- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context __attribute__((objc_requires_super));

- (void)headerRereshing __attribute__((objc_requires_super));
- (void)footerRereshing __attribute__((objc_requires_super));

/**
 *  @author wangyang, 16-05-23 14:05:00
 *
 *  因为隐藏导航栏的同时还要改变table的top约束，写这样一个方法可以方便一些
 *  @since 6.0.0
 */
- (void)hideNavigationBar;
@end
