//
//  Phobos.h
//  GengmeiDoctor
//  Data Statistic Client For Mars
//  Created by Thierry on 16/1/26.
//  Copyright © 2016年 wanmeizhensuo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PhobosPVProtocol.h"
#import <CoreLocation/CLLocation.h>

@interface Phobos : NSObject

/**
 *  @brief 开启Phobos统计,默认以BATCH方式发送log.
 *
 *  @param appName
 *  @param channelId
 *
 *  @return
 *
 *  @since 0.0.1
 */
+ (Phobos *)clientWithAppName:(NSString *)appName channelId:(NSString *)channelId;

+ (instancetype)sharedClient;

+ (void)setSharedClient:(Phobos *)client;


#pragma mark - SDK配置

// Phobos在处理业务端传递来的参数时会检查是否某个value为空，如果为空会调用这个block以通知业务层，业务层可以上报这个异常，以助解决问题
@property(nonatomic, copy) void (^captureNullExpection) (NSString *eventId, NSDictionary *info);

/**
 网络状态 wifi=1, mobile=0, 不连通=-1
 */
@property (nonatomic, copy) NSString *netStatus;


/**
 *  @brief 设置是否打印sdk的log信息,默认不开启
 *
 *  @param value 设置为YES,phobos SDK 会输出log信息,记得release产品时要设置回NO.
 *
 *  @since 0.0.1
 */
@property (assign, nonatomic) BOOL logEnabled;

/**
 *  @brief 设置当前登录用户的ID，如果没有默认为@""
 *
 *  @param userId
 *
 *  @since 0.0.2
 */
@property (assign, nonatomic) NSInteger userId;

/*!
 *  @author zhaiguojun, 16-05-31
 *
 *  @brief 用户当前的城市id
 *
 *  @param currentCityId
 *
 *  @since 0.2.7
 */
@property (strong, nonatomic) NSString *currentCityId;

@property (strong, nonatomic) CLLocation *gps;

#pragma mark - 事件采集

/**
 *  @brief 自定义事件,数量统计.
 *
 *  @param eventId 事件Id
 *  @attributes 参数
 *  @sendNow 是否实时发送，默认为NO
 *
 *  @since 0.0.1
 */
+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes;
+ (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow;
+ (void)track:(NSString *)eventId;

/**
 *  @author 翟国钧, 16-02-03 16:02:30
 *
 *  @brief H5调用的埋点方法
 *
 *  @param jsonString h5传过来的参数
 *
 *  @since 0.0.1
 */
+ (void)trackJsEvent:(NSString *)jsonString;

/**
 *  @brief PV事件开始。当controller viewWillAppear时调用
 */
- (void)onPVStart:(UIResponder<PhobosPVProtocol> *)page;
/**
 *  @brief PV事件结束。当controller viewWillDisAppear时调用
 */
- (void)onPVEnd:(UIResponder<PhobosPVProtocol> *)page;

/**
 *  @author 翟国钧, 16-03-08 11:03:45
 *
 *  @brief 有些事件需要模拟pv事件，统一用该方法处理，in out 时间相同.点击一次即触发
 *
 *  @param pageName 控件所在VC的pageName
 *  @param bid      业务id
 *  @param referer  上个月面的pagename
 *
 *  @since 5.9.1
 */
- (void)simulativePV:(NSString *)pageName businessId:(NSString *)bid referer:(NSString *)referer;

@end
