//
//  WMBaseListViewController.m
//  Gengmei
//
//  Created by Thierry on 3/5/15. Maintain by iOS Team Member.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "WMBaseListViewController.h"
#import <GMRefresh/GMRefreshFooter.h>
#import <GMRefresh/GMRefreshHeader.h>
#import <Masonry/Masonry.h>

@interface WMBaseListViewController () <OCEmptyViewDelegate>


@end

@implementation WMBaseListViewController
@synthesize table = _table;

- (void)initController{
    [super initController];
    _tableStyle = UITableViewStylePlain;
    _cellIdentifier = @"";
    _cellHeight = 0;
    self.viewModel = [[WMFetchDataViewModel alloc] init];
    _needHeaderRefresh = YES;
    _needFooterRefresh = YES;
    _immediateLoad = YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addKVO];
    
    _table = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, 0) style:_tableStyle];
    _table.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
    _table.separatorStyle = UITableViewCellSeparatorStyleNone;
    _table.rowHeight = _cellHeight;
    _table.delegate = self;
    _table.dataSource = self;

    // 如果_cellIdentifier 能转成一个UITableViewCell class，才去注册，否则会有crash发生
    if ([NSClassFromString(_cellIdentifier) isSubclassOfClass:[UITableViewCell class]]) {
        [_table registerClass:NSClassFromString(_cellIdentifier) forCellReuseIdentifier:_cellIdentifier];
    }

    _table.backgroundColor = [UIColor clearColor];
    [self.view addSubview:_table];
    [_table mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.view.mas_left);
        make.right.equalTo(self.view.mas_right);
        make.top.mas_equalTo(64);
        make.bottom.mas_equalTo(0);
    }];

    // baseList的EmptyView
    _emptyView = [[OCEmptyView alloc] initWithFrame:CGRectZero];
    _emptyView.hidden = YES;
    if([self getEmptyText].length > 0){
        _emptyView.emptyText = [self getEmptyText];
    }
    _emptyView.delegate = self;
    [self.view addSubview:_emptyView];
    [_emptyView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];

    __weak __typeof(self)weakSelf = self;
    if (_needHeaderRefresh) {
        _table.mj_header = [GMRefreshHeader headerWithRefreshingBlock:^{
            [weakSelf headerRereshing];
        }];
    }
    if (_needFooterRefresh) {
        _table.mj_footer = [GMRefreshFooter footerWithRefreshingBlock:^{
            [weakSelf footerRereshing];
        }];
    }
   
    //获取数据
    if (_immediateLoad) {
        [self loadRemoteData];
    }
}

- (void)updateOtherUIData{
    _table.hidden = NO;
}

- (void)refreshList{
    [self.viewModel setStartNum:0];
    [[self.viewModel dataArray] removeAllObjects];
    [_table reloadData];

    [self loadRemoteData];
}

- (void)loadRemoteData {
    [self showLoading:nil];
    [self.viewModel fetchRemoteData];
}

- (void)hideNavigationBar {
    self.navigationBar.hidden = YES;
    [_table mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
    }];
}

#pragma mark - TableView Delegate
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    //返回行数
    return [self.viewModel.dataArray count];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self performSelector:@selector(deselect:) withObject:tableView afterDelay:0.2f];
}

- (void)deselect:(UITableView *)tableView
{
    [tableView deselectRowAtIndexPath:[tableView indexPathForSelectedRow] animated:YES];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{

    if (tableView.rowHeight > 0) {
        return tableView.rowHeight;
    }else{
        __weak __typeof(self)weakSelf = self;
        NSAssert(_cellIdentifier.length > 0, @"WMBaseListViewController 中的tableView:heightForRowAtIndexPath 方法想使用 _cellIdentifier, 然而 _cellIdentifier 为空");
        CGFloat height = [_table fd_heightForCellWithIdentifier:_cellIdentifier cacheByIndexPath:indexPath configuration:^(UITableViewCell *cell) {
            [weakSelf configDataForCell:cell atIndexPath:indexPath];
        }];
        
        return height;
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:_cellIdentifier forIndexPath:indexPath];
    [self configDataForCell:cell atIndexPath:indexPath];
    return cell;
}

- (void)configDataForCell:(id)cell atIndexPath:(NSIndexPath *)indexPath {

}

#pragma mark - MJRefresh Delegate
/**
 *  @brief  下拉刷新
 */
- (void)headerRereshing
{
    [self.viewModel handleHeaderRefreshing];
}

/**
 *  @brief  上拉加载更多
 */
- (void)footerRereshing
{
    [self.viewModel handleFooterRereshing];
}

#pragma - mark View Model Handle
- (void)addKVO
{
    [self.viewModel addObserver:self forKeyPath:@"fetchDataSuccess" options:NSKeyValueObservingOptionNew context:NULL];
}

- (void)removeKVO{
    
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context{
    if ([keyPath isEqualToString:@"fetchDataSuccess"] && object == self.viewModel) {
        [self hideLoading];
        if ([[self.viewModel fetchDataSuccess] boolValue]) {
            if ([[self.viewModel dataArray] count] == 0) {
                [self showEmptyView:OCEmptyViewTypeEmpty];
            }else {
                [self hideEmptyView];
            }
        }else{
            [self showEmptyView:OCEmptyViewTypeException];
        }

        if (_table!=nil) {
            [_table reloadData];
            [_table.mj_header endRefreshing];
            [_table.mj_footer endRefreshing];

        }

        [self updateOtherUIData];
    }
}


- (void)showEmptyView:(OCEmptyViewType)type {
    _emptyView.type = type;
    _emptyView.hidden = NO;
    [self getEmptyText];
    [_emptyView setNeedsLayout];
}

- (void)hideEmptyView {
    _emptyView.hidden = YES;
}


- (void)dealloc{
    [self removeKVO];
    // 因为fetchDataSuccess是在viewDidLoad中监听的，所以需要一个判断
    if ([self isViewLoaded]) {
        [self.viewModel removeObserver:self forKeyPath:@"fetchDataSuccess"];
    }
}

#pragma mark - OCEmptyViewDelegate

- (void)emptyViewDidClickReload{
    [self loadRemoteData];
}

- (NSString *)getEmptyText{
    if (self.viewModel.message.length > 0) {
        return self.viewModel.message;
    }
    return @"";
}


@end
