//
//  WMBaseCollectionController.h
//  Gengmei
//
//  Created by wangyang on 9/2/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "WMBaseViewController.h"
#import "WMFetchDataViewModel.h"

@interface WMBaseCollectionController : WMBaseViewController <UICollectionViewDelegateFlowLayout,UICollectionViewDataSource>{
    BOOL _needHeaderRefresh;
    BOOL _needFooterRefresh;
    
    WMFetchDataViewModel *_viewModel;
    UICollectionView *_collectionView;
    UICollectionViewLayout *_collectionViewLayout;
}
@property (nonatomic, strong) WMFetchDataViewModel *viewModel;
/** @brief 控制当前VC的viewmodel是不是立即请求网络 **/
@property (nonatomic , assign) BOOL immediateLoad;
/**
 *  @brief  默认大小是self.view.bounds
 */
@property (nonatomic, strong) UICollectionView *collectionView;

/**
 *  @brief  默认返回一个 flowLayout
 @code
 minimumLineSpacing = 0;
 minimumInteritemSpacing = 0;
 itemSize = CGSizeMake(50, 50);
 @endcode

 详见具体实现
 */
@property (nonatomic, strong) UICollectionViewLayout *collectionViewLayout;
- (void)updateOtherUIData __attribute__((objc_requires_super));

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context __attribute__((objc_requires_super));
- (void)refreshList;
- (void)loadRemoteData;
- (void)headerRereshing;
- (void)footerRereshing;

- (void)hideNavigationBar;
- (void)hideEmptyView;

- (void)addKVO;
- (void)removeKVO;
@end
