//
//  GMLiveLikeView.m
//  Gengmei
//
//  Created by licong on 2017/1/6.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMLiveLikeView.h"
#import "GMButton.h"
@import GMKit;
@interface GMLiveLikeView ()

@property (strong ,nonatomic) GMButton *button;

@end


@implementation GMLiveLikeView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        
        [self setup];
    }
    return self;
}

- (void)setup{
        
    _button = [GMButton buttonWithType:UIButtonTypeCustom];
    _button.frame  = self.bounds;
    _button.enableAdaptive = YES;
    _button.adjustsImageWhenHighlighted  = NO;
    [_button setImage:[UIImage imageNamed:@"live_heart_nor"] forState:UIControlStateNormal];
    [_button addTarget:self action:@selector(likeButtonClicked) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_button];
}

- (void)layoutSubviews{
    [super layoutSubviews];
    _button.frame  = self.bounds;
}

- (void)likeButtonClicked{
    UIView * gradientView = [[UIView alloc]
                     initWithFrame:self.bounds];
    gradientView.frame = self.bounds;
    gradientView.layer.cornerRadius = self.frame.size.height/2;
    gradientView.userInteractionEnabled  = NO;
    gradientView.center = CGPointMake(self.frame.size.width/2, self.frame.size.height/2);
    gradientView.layer.cornerRadius = self.frame.size.height/2;
    gradientView.backgroundColor = RGBCOLOR_HEX(0xFF7690);
    gradientView.hidden = YES;
    [self addSubview:gradientView];
    gradientView.alpha = 1;
    gradientView.hidden = NO;
    gradientView.transform = CGAffineTransformMakeScale(1, 1);
    [_button setImage:[UIImage imageNamed:@"live_heart_pre"] forState:UIControlStateNormal];
    
    
    [UIView animateWithDuration:0.3
                     animations:^{
                         gradientView.alpha = 0.3;
                         gradientView.transform = CGAffineTransformMakeScale(2, 2);
                     }completion:^(BOOL finish){
                         [gradientView removeFromSuperview];
                         [_button setImage:[UIImage imageNamed:@"live_heart_nor"] forState:UIControlStateNormal];
                     }];
    if (self.liveLikeClickedBlock) {
        self.liveLikeClickedBlock();
    }
}



@end
