//
//  WYSegmentView+Factory.m
//  Gengmei
//
//  Created by wangyang on 16/2/17.
//  Copyright © 2016年 Wanmeichuangyi. All rights reserved.
//

#import "WYSegmentView+Factory.h"
@import GMKit;
@implementation WYSegmentView (Factory)

+ (WYSegmentView *)baseThemeSegment {
    WYSegmentView *segment = [[WYSegmentView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 40)];
    segment.backgroundColor = [UIColor whiteColor];
    segment.showIndicator = YES;
    return segment;
}

+ (WYSegmentView *)dynamicSegment {
    WYSegmentView *segment = [self baseThemeSegment];
    segment.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:15],
                                    NSForegroundColorAttributeName:UIColor.auxiliaryTextDark};
    segment.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:15],
                                            NSForegroundColorAttributeName:UIColor.headlineText};
    segment.scrollView.contentInset = UIEdgeInsetsMake(0, 6, 0, 6);
    segment.widthStyle = WYSegmentViewWidthStyleDynamic;
    segment.itemHorizonalPadding = 14;
    return segment;
}

+ (WYSegmentView *)fullWidthSegment {
    WYSegmentView *segment = [self baseThemeSegment];
    segment.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:15],
                                    NSForegroundColorAttributeName:UIColor.auxiliaryTextDark};
    segment.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:15],
                                            NSForegroundColorAttributeName:UIColor.headlineText};
    segment.widthStyle = WYSegmentViewWidthStyleEqual;
    return segment;
}

+ (WYSegmentView *)myOrderListSegment {
    WYSegmentView *segment = [self baseThemeSegment];
    segment.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:15],
                                    NSForegroundColorAttributeName:UIColor.auxiliaryTextDark};
    segment.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:15],
                                            NSForegroundColorAttributeName:UIColor.headlineText};
    segment.widthStyle = WYSegmentViewWidthStyleEqual;
    return segment;
}
@end
