//
//  OCEmptyView.m
//  Gengmei
//
//  Created by wangyang on 16/7/9.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "OCEmptyView.h"
#import "GMBaseUtil.h"
#import <Masonry/Masonry.h>

@implementation OCEmptyView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)awakeFromNib{
    [super awakeFromNib];
    [self setup];
}

- (void)setup{
    self.backgroundColor = [UIColor colorWithhex:0xf0f0f0];
    _tipIcon = [UIImageView new];
    _tipLabel = [UILabel new];
    _tipButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [self addSubview:_tipIcon];
    [self addSubview:_tipLabel];
    [self addSubview:_tipButton];

    _tipLabel.numberOfLines = 2;
    _tipLabel.textColor = [UIColor colorWithhex:0x999999];
    _tipLabel.font = [UIFont navigationFontWithSize:14];
    _tipLabel.textAlignment = NSTextAlignmentCenter;

    _tipButton.layer.borderColor = [UIColor colorWithhex:0xd5d5d5].CGColor;
    _tipButton.layer.borderWidth = 1.0/[UIScreen mainScreen].scale;
    _tipButton.hidden = YES;
    [_tipButton setTitle:@"重新加载" forState:UIControlStateNormal];
    _tipButton.titleLabel.font = [UIFont navigationFontWithSize:14];
    [_tipButton setTitleColor:[UIColor colorWithhex:0x666666] forState:UIControlStateNormal];
    [_tipButton addTarget:self action:@selector(reloadBtnTap) forControlEvents:UIControlEventTouchUpInside];

    _exceptionImage = @"network_failed_icon";
    _exceptionText = @"网络请求失败，请检查您的网络设置";
    _emptyImage = @"empty_icon";
    _emptyText = @"";
}

- (void)layoutSubviews {
    [super layoutSubviews];
    switch (self.type) {
        case OCEmptyViewTypeEmpty: {
            _tipIcon.image = [UIImage imageNamed:_emptyImage];
            _tipLabel.text = _emptyText;
            _tipButton.hidden = YES;
            [_tipIcon mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.centerX.equalTo(self);
                make.centerY.equalTo(self).offset(-50);
                make.width.mas_equalTo(140);
                make.height.mas_equalTo(93);
            }];
            [_tipLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.top.equalTo(_tipIcon.mas_bottom).offset(25);
                make.height.mas_equalTo(50);
                make.width.mas_equalTo(280);
                make.centerX.mas_equalTo(self);
            }];

            break;
        }
        case OCEmptyViewTypeException: {
            _tipIcon.image = [UIImage imageNamed:_exceptionImage];
            _tipLabel.text = _exceptionText;
            _tipButton.hidden = NO;
            [_tipIcon mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.centerX.equalTo(self);
                make.centerY.equalTo(self).offset(-50);
                make.width.mas_equalTo(100);
                make.height.mas_equalTo(81);
            }];
            [_tipLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.height.mas_equalTo(25);
                make.top.equalTo(_tipIcon.mas_bottom).offset(15);
                make.centerX.equalTo(self);
            }];
            [_tipButton mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.top.equalTo(_tipLabel.mas_bottom).offset(15);
                make.centerX.equalTo(self);
                make.width.mas_equalTo(90);
                make.height.mas_equalTo(30);
            }];
        }
        default:
            break;
    }
}
- (void)reloadBtnTap {
    if ([self.delegate respondsToSelector:@selector(emptyViewDidClickReload)]) {
        [self.delegate emptyViewDidClickReload];
    }
}
@end

