//
//  OCNavigatioinBar.h
//  Pods
//
//  Created by wangyang on 16/7/8.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
@class OCNavigatioinBarButton;
@protocol OCNavigatioinBarDelegate <NSObject>
- (void)rightButtonClicked:(OCNavigatioinBarButton *)button;
- (void)nearRightButtonClicked:(OCNavigatioinBarButton *)button;
- (void)backAction:(OCNavigatioinBarButton *)button;
@end

/**
 *  @author wangyang
 *
 *  作为单独组件后，导航栏按键具体值应该由业务层控制。这里不再关心
 */
@interface OCNavigatioinBar : UIView
@property (nonatomic, weak) id<OCNavigatioinBarDelegate> delegate;
// OCNavigatioinBar 高度是64，itemView的y坐标从20开始，高44。titleLabel，titleView，backButton，rightButton，nearRightButton都是被添加到该itemView中的
@property (nonatomic, strong, readonly) UIView *itemView;
@property (nonatomic, strong, readonly) UILabel *titleLabel;

// 就像系统导航栏的titleView的用法
@property (nonatomic, strong, nullable) UIView *titleView;
@property (nonatomic, copy, nullable) NSString *title;

@property (nonatomic, strong, readonly) OCNavigatioinBarButton *leftButton;
@property (nonatomic, strong, readonly) OCNavigatioinBarButton *rightButton;
@property (nonatomic, strong, readonly) OCNavigatioinBarButton *nearRightButton;

@property (nonatomic, copy, nullable) NSString *leftIcon;
@property (nonatomic, copy, nullable) NSString *rightIcon;
@property (nonatomic, copy, nullable) NSString *nearRightIcon;

@property (nonatomic, copy, nullable) NSString *leftTitle;
@property (nonatomic, copy, nullable) NSString *rightTitle;
@property (nonatomic, copy, nullable) NSString *nearRightTitle;

/// 默认显示阴影（严格来说是一条线，并不是阴影）
- (void)showShadow:(BOOL)show;
- (void)hideAllItems;
@end


@interface OCNavigatioinBarButton : UIButton

@end

NS_ASSUME_NONNULL_END
