//
//  GMClientH5Object.h
//  Gengmei
//
//  Created by wangyang on 7/25/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <JavaScriptCore/JavaScriptCore.h>

// 设置打开的权限类型
typedef NS_ENUM(NSInteger, GMSettingType) {
    // 推送
    GMSettingTypePush,
    // 位置
    GMSettingTypeLocation
};

/**
 *  @brief  在这里声明js对象所有绑定的方法(名字要和js注册的方法保持一致),命名规范以JS端为准
 */
@protocol GMClientH5Bridge <JSExport>


#pragma mark - 下面这些放到Base里


/***  @brief  返回到上级页面*/
- (void)jsPop:(BOOL)animated;

/***  @brief  返回域名, 这个不需要代理在controller实现*/
- (NSString *)domain;

/***  @brief  弹出loading框*/
- (void)showLoading;

/***  @brief  隐藏loading*/
- (void)hideLoading;

/***  @brief  Alert弹窗（只有一个确认按钮）*/
- (void)showAlert:(NSString *)JSONString;

/***  @brief  Confirm弹窗（确认和取消按钮*/
- (void)showConfirm:(NSString *)JSONString;

/***  @brief  toast弹窗*/
- (void)showToast:(NSString *)JSONString;


/*** @brief 埋点功能 ，js掉native方法方式埋点 */
- (void)trackEvent:(NSString *)JSONString;

/*** @brief 精准曝光 */
- (void)hybridExposure:(NSString *)JSONString;

/*** @brief 回放 */
- (void)playVideo:(NSString *)JSONString;

/*** @brief 获取通讯录 */
- (void)getAddressBook;

/*** 选择一个联系人 */
- (void)chooseOneContactPerson:(NSString *)key;;

- (void)logout;

/***  @brief  打开外部浏览器*/
- (void)openBrowser:(NSString *)url;


/**
 *  @author wangyang, 16-03-11 15:03:43
 *
 *  @brief 如果目前没有地理位置权限，h5调用该方法跳转到系统的定位功能
 *  @since 5.9.2
 */
- (void)jumpToLocationSettings;


/**
 *  @author wangyang, 16-03-11 15:03:43
 *
 *  @brief 如果目前没有地理位置权限，h5调用该方法显示弹窗，要求获取权限
 *  @since 5.9.2
 */
- (void)locationShowAlertIfNotAllowed;


/***  @brief  显示分享美券页面
 邀请好友, 所长发券页在使用。使用了globalObjectLoaded
 */
- (void)jsObjShowShareView:(NSString *)JSONString;

/***  @brief  分享日记
 连续签到，补签
 */
- (void)jsObjShowDiaryShareView:(NSString *)JSONString;

/***  @brief  显示小分享（仅微信好友/微信朋友圈）页面
 在老版本的支付完成页使用，先弹出一个本地的分享视图，再分享。从6.2.0开始已经不再使用
 */
- (void)showWXShareView:(NSString *)JSONString;

//抛出两个方法让服务器存储使用

- (void)setLocalStorage:(NSString *)key WithBody:(NSString *)value;

- (NSString *)getLocalStorage:(NSString *)key;

//秒杀页面是否展示定位
- (BOOL)isLocationEnable;
/**
 *  @author wangyang, 16-01-22 18:01:16
 *
 *  @brief H5 主动调用本地分享方法，直接分享到某个平台。在订单详情页发红包弹出的webView里被调用
 *  @param data  JSON
 *  @param type  QZone/QQ/Wechat/WechatMoments/SinaWeibo
 *  @since 5.9.0
 */
- (void)share:(NSString *)shareDataString withType:(NSString *)type;

/**
 *  @author wangjun, 16-07-04 12:07:24
 *
 *  秒杀页面的添加到系统日历的事件的方法
 *  @param jsonString json字符串
 *  @since 6.1.0
 */
- (void)remindEvent: (NSString *)jsonString;

///保险回调
- (void)insurancePurchase:(BOOL)hasBought;

///打电话
- (void)callPhone:(NSString *)phone;
///发短信
- (void)sendMessage:(NSString *)phone withBody:(NSString *)body;
//日记本详情打开通知Alert
- (void)diaryDetailShowNotificationAlert;

/**
 用来动画导航栏的。参考日记帖详情页PostDetailViewController
 @param height 可动画的高度
 */
- (void)setHeaderHeight:(NSInteger)height;

// 从h5登录，保存session及用户信息
- (void)syncSSOInfo:(NSString *)info;
//场景化弹窗
- (void)showTaskAlert:(NSString *)extra;

// 新用户领券是否成功
- (void)newbieCouponGot:(NSInteger)flag;


/**
 邀请好友粘贴口令

 @param boardText 口令值
 */
- (void)clipboard:(NSString *)boardText;

/**
 回复框弹窗

 @param jsonString 弹窗内容和回调方法
 */
- (void)showActionSheet:(NSString *)jsonString;

/**
 右上角关注按钮

 @param json icon_url:关注/未关注图片
 */
- (void)rightbuttonCallBack:(NSString *)json;

/**
 机构主页

 @param jsonString pageData
 */
- (void)globalDataLoaded:(NSString *)jsonString;

/**
 是否登录:1登录 0未登录
 */
- (int)isUserLogin;

/**
 获取用户信息
 */
- (NSString *)inflateUserInfo;

/**
 机构详情：yes:导航栏显示，no:导航栏隐藏
 */
- (void)controlTitleBarVisible:(NSString *)jsonString;

/**
 回复详情：底栏数据
 */
- (void)answerData:(NSString *)jsonString;

/**
 问题详情：底栏数据
 */
- (void)questionData:(NSString *)jsonString;

/**
 导航栏高度
 */
- (int)navigationbarHeight;

/**
 签到提醒开关
 */
- (void)checkAuthority:(NSString *)jsonString;

/**
 网络状态 2： 其他 1:wifi 0:无网络
 */
- (NSInteger)checkNetworkState;

- (NSString *)nativeDataLoaded;

/**
 签到页弹窗点击不再提醒
 */
- (void)signNeverNotify;


/**
 展示空的页面
 */
-(void)showNativeEmptyView;

/**
 调起第三方APP
 */
- (void)skipToThirdApp:(NSString *)jsonString;

/**
 面孔起源结果页跳转列表页
 */
- (void)jumpToResearchPage:(NSString *)url;

/**
 面诊记录报告页面保存图片
 */
- (void)saveImage:(NSString *)url;
/**
 调起评论列表
 */
- (void)showCommentList:(NSString *)JSONString;

@end



/***  @brief  在这里声明 js 要调用的方法*/
@protocol GMClientH5BridgeDelegate <NSObject>
@optional

/***  @brief  显示分享美券页面*/
- (void)jsObjShowShareViewWithJSONString:(NSString *)JSONString;

/***  @brief  连续签到，补签分享日记*/
- (void)jsObjShowDiaryShareViewWithJSONString:(NSString *)JSONString;

/***  @brief  显示小分享（仅微信好友/微信朋友圈）页面*/
- (void)jsShowWXShareViewWithJSONString:(NSString *)JSONString;

/***  @brief  返回到上级页面*/
- (void)jsPopViewControllerAnimated:(BOOL)animated;

/***  @brief  弹出loading框*/
- (void)jsShowLoading;

- (void)jsShowNativeEmptyView;

/***  @brief  隐藏loading*/
- (void)jsHideLoading;

/***  @brief  Alert弹窗（只有一个确认按钮）*/
- (void)jsShowAlertViewWithJSONString:(NSString *)JSONString;

/***  @brief  Confirm弹窗（确认和取消按钮*/
- (void)jsShowConfirmViewWithJSONString:(NSString *)JSONString;

/***  @brief  toast弹窗*/
- (void)jsShowToastWithJSONString:(NSString *)JSONString;

/*** @brief 供h5吊起选图上传的方法 */
- (void)jsOpenAlbum:(NSString *)requestCode is_private:(BOOL)isPrivate;

/*** @brief 获取通讯录 */
- (void)jsGetAddressBook;

- (void)jsChooseOneContactPerson:(NSString *)key;

/**
 *  @author wangyang, 15-10-08 15:10:56
 *
 *  @brief 见 applyForStage 方法
 *  @since 5.2.0
 */
- (void)jsApplyForStage:(NSString *)url;

/*** @brief 埋点功能 ，js掉native方法方式埋点 */
- (void)jsTrackEvent:(NSString *)JSONString;

/*** @brief 精准曝光 */
- (void)jsHybridExposure:(NSString *)JSONString;

/*** @brief 回放 */
- (void)jsPlayVideo:(NSString *)JSONString;

/**
 *  @author wangyang, 16-12-31 16:12:05
 *
 *  @brief h5 调用注销方法
 *  @since 5.8.0
 */
- (void)jsLogout;

/**
 *  @author wangyang, 16-01-22 18:01:03
 *
 *  @brief 见 share:withType:
 *  @since 5.9.0
 */
- (void)jsShare:(NSString *)shareDataString withType:(NSString *)type;
//以便H5存储使用
- (void)jsSetLocalStorage:(NSString *)key withStorage:(NSString *)value;
- (NSString *)jsGetLocalStorage:(NSString *)key;


/***  @brief  打开外部浏览器*/
- (void)jsOpenBrowser:(NSString *)url;

/**
 *  @author wangyang, 16-03-11 15:03:43
 *
 *  @brief 如果目前没有地理位置权限，h5调用该方法跳转到系统的定位功能
 *  @since 5.9.2
 */
- (void)jsJumpToLocationSettings;

//秒杀页面是否需要展示打开定位
- (BOOL)jsIsLocationEnable;
/**
 *  @author wangyang, 16-03-11 15:03:43
 *
 *  @brief 如果目前没有地理位置权限，h5调用该方法显示弹窗，要求获取权限
 *  @since 5.9.2
 */
- (void)jsLocationShowAlertIfNotAllowed;
/**
 *  @author wangjun, 16-03-17 16:03:12
 *
 *  @brief 赚美分页面的动画效果
 *
 *  @param dict H5调用所传的参数字典
 *
 *  @since 5.9.2
 */
- (void)jsShowBong:(NSString *)jsonString;

/**
 *  @author wangjun, 16-07-04 12:07:08
 *
 *  秒杀页面的添加到系统日历的事件的方法
 *  @param jsonString H5穿来的json字符串
 *  @since 6.1.0
 */
- (void)jsRemindEvent:(NSString *)jsonString;

/**
 *  保险状态返回 
 *  @paramhas_bought: true(确定购买) / false(取消购买)
 *  @since 6.6.0
 */

- (void)jsInsurancePurchase:(NSDictionary *)dict;
///打电话
- (void)jsCallPhone:(NSString *)phone;
///发短信
- (void)jsSendMessage:(NSString *)phone withBody:(NSString *)body;

- (void)jsSetHeaderHeight:(NSInteger)height;

// 打开通知方法
- (void)jsDiaryDetailShowNotificationAlert;

// 前端登录信息同步到客户端
- (void)jsSyncSSOInfo:(NSString *)info;
//场景化弹窗由JS调用
- (void)jsShowTaskAlert:(NSString *)extra;
// 新用户领券是否成功
- (void)jsNewbieCouponGot:(NSInteger)flag;


/**
 邀请好友粘贴口令

 @param boardText 口令值
 */
- (void)jsClipboard:(NSString *)boardText;

/**
 回复弹窗

 @param jsonString 弹窗名称和回调方法
 */
- (void)jsShowActionSheet:(NSString *)jsonString;

/**
 右上角关注按钮
 
 @param json icon_url:关注/未关注图片
 */
- (void)jsRightbuttonCallBack:(NSString *)json;

/**
 机构主页

 @param jsonString pageData
 */
- (void)jsGlobalDataLoaded:(NSString *)jsonString;

/**
 是否登录
 */
- (int)jsIsUserLogin;

/**
 获取用户信息
 */
- (NSString *)jsInflateUserInfo;

- (NSString *)jsNativeDataLoaded;

/**
 机构详情：yes:导航栏显示，no:导航栏隐藏
 */
- (void)jsControlTitleBarVisible:(NSString *)jsonString;

/**
 回复详情：底栏数据
 */
- (void)jsAnswerData:(NSString *)jsonString;

/**
 问题详情：底栏数据
 */
- (void)jsQuestionData:(NSString *)jsonString;

/**
 导航栏高度
 */
- (int)jsNavigationbarHeight;

/**
 签到提醒开关
 */
- (void)jsCheckAuthority:(NSString *)jsonString;

/**
 网络状态 2： 其他 1:wifi 0:无网络
 */
- (NSInteger)jsCheckNetworkState;

/**
 签到页弹窗点击不再提醒
 */
- (void)jsSignNeverNotify;

/**
 调起第三方APP
 */
- (void)jsSkipToThirdApp:(NSString *)jsonString;


/// js 直接掉起指定平台分享
/// @param jsonString 分享数据
- (void)jsSharewithType:(NSDictionary *)data;

/// 更新页面上导航数据
/// @param JSONString @param JSONString {"title":"","business_id":""}
- (void)jsScrollSetHeader:(NSDictionary *)data;


/// 弹出l评论列表+评论输入
/// @param data @param JSONString {"title":"","business_id":""}
- (void)jsShowCommentList:(NSDictionary *)data;

/// 弹出回答输入框
/// @param data @param JSONString
- (void)jsShowAnswerInput:(NSDictionary *)data;

/**
 面孔起源结果页跳转列表页
 */
- (void)jsJumpToResearchPage:(NSString *)url;

/**
 面诊记录报告页面保存图片
 */
- (void)jsSaveImage:(NSString *)url;

/// 查看今日运势( isSaveSocial： 是否保存到社区)
/// @param data @param JSONString {"isSaveSocial":"1"}
- (void)jsShowToDayLuck:(NSDictionary *)data;
@end


@interface GMClientH5Object : NSObject <GMClientH5Bridge>

@property (nonatomic, weak) id<GMClientH5BridgeDelegate> delegate;
@end
