//
//  GMWebViewComponent.swift
//  Gengmei
//
//  Created by Terminator on 2017/11/9.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

import UIKit
import WebKit
import GMBaseSwift
import GMUtil

@objc protocol WKWebViewDelegate: class {
    // 这是对外暴露的方法
    @objc optional func handleLinkTap(_ url: String, host: String?, params: [String: AnyObject]?)
    @objc optional func handleGlobalPageData(_ data: [String: AnyObject])
    /// 数据请求成功h5调起
    @objc optional func globalPageData(_ data: NSDictionary)
    // 机构详情
    @objc optional func globalDataLoaded(_ data: NSDictionary)
    // 7770 i帖子头部切换
    @objc optional func scrollSetHeader(_ data: NSDictionary)
    // 导航栏隐藏显示
    @objc optional func controlTitleBarVisible(_ show: Bool)
    @objc optional func diaryDetailControllerShowNotificationAlert()
    /// webView页面点击分享调起(没有share_data包裹)
    @objc optional func webViewShareData(_ data: NSDictionary)
    // 人脸分析之后点击分享传给客户端图片
    @objc optional func shareFaceInfoImageMethod(_ imageString: String)
    // 测肤分享图片传给客户端图片
    @objc optional func shareSkinInfoImageMethod(_ imageString: String)
    // 面孔起源分享图片传给客户端图片
    @objc optional func shareResearchInfoImageMethod(_ imageString: String)
    // 分享base64图片 {"imageString" : base64_String}
    @objc optional func shareBase64ImageMethod(_ imageString: String)
    // 工作台-面诊报告列表-投诉弹框
    @objc optional func videoDiagnoseComplaint(_ data: NSDictionary)
    // 保存视频方法
    @objc optional func saveFaceVideo(_ jsonString: String)
    // 播放视频方法
    @objc optional func playFaceVideo()
    
    // 是否展示空页面
    @objc optional func showNativeEmptyView()
    
    @objc optional func insurancePurchase(_ hasBought: Bool)
    // 获取native本地公共参数
    @objc optional func nativeDataLoaded() -> String
    //获取用户信息
    @objc optional func inflateUserInfo() -> String
    // 实时获取数据返回值
    @objc optional func onLineGetData(_ data: NSDictionary)
    //修改用户头像
    @objc optional func changeAvatar()
    // 扫脸结果页获取im链接
    @objc optional func consultationUrl(_ data: NSDictionary)
    // 判断是否滑动到了底部
    @objc optional func jsPageReachBottom(_ isScrollbottom: Bool)
    // 测肤返回到首页
    @objc optional func jsControlBackToMethod(_ jsonString: String)
    // 扫脸页接口请求完成，隐藏loading
    @objc optional func closeFaceLoading()
    /// H5 指定分享平台
    @objc optional func jsSharewithType(_ data: NSDictionary)
    /// 回复弹框
    @objc optional func jsShowActionSheet(_ data: NSDictionary)
    // 面孔起源结果页跳转列表页
    @objc optional func jsJumpToResearchPage(_ url: String)
    // 精准曝光
    @objc optional func hybridExposure(_ data: NSDictionary)
    // 相机和麦克风权限
    @objc optional func getVideoPermission(_ data: NSDictionary)
    // 关闭视频面诊基本信息弹窗
    @objc optional func closeCurrentPage()
    // 视频面诊基本信息
    @objc optional func showVideoBasicInfo(_ jsonString: String)
    // 面诊记录列表查看评价与去评价
    @objc optional func viewEvaluate(_ jsonString: String)
    // 面诊记录列表查看投诉
    @objc optional func viewComplaint(_ jsonString: String)
    // 面诊订单列表确定订单
    @objc optional func viewConfirm(_ jsonString: String)
    // 面诊订单详情弹出投诉弹窗
    @objc optional func showComplaint(_ jsonString: String)
    // 展示评论列表
    @objc optional func jsShowCommentList(_ string: String)
    // 面诊弹窗
    @objc optional func showCounsellorCard(_ string: String)
    // 面诊弹窗全部卡片
    @objc optional func showAllCard()
    // 遮罩
    @objc optional func showClientShadow(_ data: NSDictionary)
}

///考虑到要做成一个库不想要那么重的继承任务
@objcMembers
class GMWebViewComponent: UIView {
    
    /// 事件
    fileprivate weak var target: AnyObject?
    ///webcomponet
    var webView = WKWebView()
    
    /// 创建一个webiview的配置项
    fileprivate let configuretion = WKWebViewConfiguration()
    fileprivate let userContent = WKUserContentController()
    fileprivate var showInputDic = NSDictionary()
    var popupView: GMPopUpView!
    
    var moreQueryParams = ""
    var fullUrl = ""
    var path = ""
    
    /// 不立即请求
    var isImmediateRequest = true
    
    /// WebView配置项
    var webEngine = GMWebEngine()
    
    var clientH5Object = GMClientH5Object()
    /// 进度条
    var progressView: UIProgressView!
    // 弹出键盘view
    var showInputView = WMPostInputView()
    //设置代理
    weak var delegate: WKWebViewDelegate?
    fileprivate var titleObserve: NSKeyValueObservation!
    fileprivate var estimatedProgressObserve: NSKeyValueObservation!
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        configure()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        configure()
    }
    
    fileprivate func configure() {
    }
    
    //初始化Preferences
    fileprivate func initPreferences() {
        configuretion.preferences = WKPreferences()
        configuretion.processPool = WKProcessPool.sharedProcessPool()
        configuretion.preferences.minimumFontSize = webEngine.minFontSize
        configuretion.preferences.javaScriptEnabled = webEngine.isAutomaticallyJavaScript
        // 需要WKWebView支持页面内视频播放
        configuretion.allowsInlineMediaPlayback = true
        if #available(iOS 10.0, *) {
            configuretion.mediaTypesRequiringUserActionForPlayback =  WKAudiovisualMediaTypes.init(rawValue: 0)
        } else {
            configuretion.mediaPlaybackRequiresUserAction = false
        }
        
    }
    
    /**
     初始化userContent
     同步Ajax Cookie
     */
    fileprivate func initUserContent() {
        userContent.add(self, name: "gmclient")
        let ajaxCookieScript = WKUserScript(source: webEngine.ajaxCookie(), injectionTime: .atDocumentStart, forMainFrameOnly: false)
        userContent.addUserScript(ajaxCookieScript)
        configuretion.userContentController = userContent
        _ = webEngine.scriptMessageHandlerArray.map { [unowned self] (handlerName) in
            self.userContent.add(self, name: handlerName)
        }
    }
    
    func initProgressView() {
        //进度条
        progressView = UIProgressView(progressViewStyle: UIProgressViewStyle.bar)
        progressView.progressTintColor = UIColor.mainVisual
        addSubview(progressView)
        progressView.snp.makeConstraints { (make) in
            make.top.left.right.equalTo(0)
            make.height.equalTo(1)
        }
    }
    
    func initShowInputView(_ view: UIView) {
        // 弹出键盘
        showInputView = WMPostInputView()
        showInputView.delegate = self
        showInputView.isHidden = true
        
        showInputView.removeFromSuperview()
        view.addSubview(showInputView)
        showInputView.snp.makeConstraints { (make) in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalTo(0)
            make.top.equalTo(OCNavigationBar.barHeight)
        }
    }
    
    func initPopUpView(_ title: String) {
        popupView = GMPopUpView()
        popupView.delegate = self.delegate as? GMPopupBgViewDelegate
        popupView.title = title
        popupView.fullUrl = fullUrl
        AppDelegate.visibleController.view.addSubview(popupView)
    }
    
    fileprivate func initWebView(_ webEngine: GMWebEngine) {
        webView.removeFromSuperview()
        webView = WKWebView(frame: CGRect.zero, configuration: configuretion)
        webView.uiDelegate = self
        webView.navigationDelegate = self
        if #available(iOS 11.0, *) {
            webView.scrollView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentBehavior.never
        }
        //开启手势交互
        webView.allowsBackForwardNavigationGestures = webEngine.isAllowsBackForwardGestures
        //滚动条
        webView.scrollView.showsVerticalScrollIndicator = webEngine.isShowScrollIndicator
        webEngine.webView = webView
        addSubview(webView)
        //内容自适应
        webView.snp.makeConstraints { (make) in
            make.left.top.right.bottom.equalTo(0)
        }
    }

    func wrapUrl() -> String {
        var para = AppDelegate.shareInstance().urlCommonParameters()!
        if fullUrl.isNonEmpty() {
            if !fullUrl.contains("&device_id=") {
                if fullUrl.contains("?") {
                    let  startIndex = para.startIndex
                    let  endIndex = para.index(startIndex, offsetBy: 0)
                    let  range = startIndex...endIndex
                    para.replaceSubrange(range, with: "&")
                }
                fullUrl = "\(fullUrl)\(para)"
            }
            if self.moreQueryParams.isNonEmpty() {
                fullUrl = "\(fullUrl)\(self.moreQueryParams)"
            }
            return fullUrl.trimSpace()
        } else {
            let apihost = GMServerDomains.apiHost!
            let url = "\(apihost)/hybrid\(path)\(para)\(self.moreQueryParams)"
            return url
        }
    }
    
    ///发送Request
    public func sendRequest() {
        let urlString = wrapUrl()
        if urlString.isEmpty {
            return
        }
        let url = URL(string: urlString)!
        let urlHost = url.host ?? ""
        let isAllow = GMServerDomains.allowURLHost(urlHost)
        if isAllow == false {
    #if DEBUG
        UIAlertController.showOKAlert(withTitle: "webView需添加白名单")
    #endif
            return
        }
        
        let request = NSMutableURLRequest(url: url, cachePolicy: .reloadRevalidatingCacheData, timeoutInterval: 30)
        request.setValue(webEngine.webCookie(), forHTTPHeaderField: "Cookie")
        webView.load(request as URLRequest)
    }
    
    func webviewLoad(_ target: AnyObject) {
        self.target = target
        initPreferences()
        initUserContent()
        initWebView(webEngine)
        initProgressView()
        initShowInputView(self)
        addObserver()
        if fullUrl.isNonEmpty() || path.isNonEmpty() {
            sendRequest()
        }
    }
    
    /// 刷新
    public func reload() {
        //防止 登陆后缓存 修改不同步问题
        let ajaxCookieScript = WKUserScript(source: webEngine.ajaxCookie(), injectionTime: .atDocumentStart, forMainFrameOnly: false)
        self.userContent.addUserScript(ajaxCookieScript)
        webEngine.syncCookies()
        sendRequest()
        webView.isUserInteractionEnabled = false
    }
    
    public func loadJsCode(jsCode: String) {
        // 根据JS字符串初始化WKUserScript对象
        self.webView.evaluateJavaScript(jsCode) { (value, error) in
            debugLog(error)
            debugLog(value)
        }

    }
    
    /// 后退
    public func goBack() {
        webView.goBack()
    }
    /// 前进
    public func goForward() {
        webView.goForward()
    }

    /// 移除webView
    public func removeWebView() {
        webView.scrollView.delegate = nil
        NotificationCenter.default.removeObserver(self, name: NSNotification.Name(rawValue: LOGIN_SUCCESS_NOTIFICATION), object: nil)
        titleObserve?.invalidate()
        estimatedProgressObserve?.invalidate()
        userContent.removeAllUserScripts()
        _ = webEngine.scriptMessageHandlerArray.map { [unowned self] (handlerName) in
            self.userContent.removeScriptMessageHandler(forName: handlerName)
        }
        userContent.removeScriptMessageHandler(forName: "gmclient")
        self.webView.navigationDelegate = nil
        self.webView.uiDelegate = nil
    }

    override func willMove(toSuperview newSuperview: UIView?) {
        if newSuperview == nil {
            removeWebView()
        }
    }

    func addObserver() {
        titleObserve = webView.observe(\.title) { [unowned self] (_, _) in
            guard let controller = self.target as? WMBaseViewController else {
                return
            }
            controller.navigationBar.title = self.webView.title ?? ""
            controller.title = self.webView.title ?? ""
        }

        estimatedProgressObserve = webView.observe(\.estimatedProgress, options: .new) { [unowned self] (_, change) in
            if let currentProgress = change.newValue {
                self.progressView.setProgress(Float(currentProgress), animated: true)
                if Float(currentProgress) == 1 {
                    self.webView.isUserInteractionEnabled = true
                }
            }
        }
        NotificationCenter.default.addObserver(self, selector: #selector(reload), name: NSNotification.Name(rawValue: LOGIN_SUCCESS_NOTIFICATION), object: nil)
    }
}
// MARK: - WKNavigationDelegate
extension GMWebViewComponent: WKNavigationDelegate {
    
    ///开始发送Request
    func webView(_ webView: WKWebView, didStartProvisionalNavigation navigation: WKNavigation!) {
        debugLog("didStartProvisionalNavigation")
        progressView.removeFromSuperview()
        initProgressView()
        progressView.isHidden = false
    }
    
    /**
     Request请求完毕，内容开始返回
     */
    func webView(_ webView: WKWebView, didCommit navigation: WKNavigation!) {
        debugLog("didCommitNavigation")
    }
    
    /// 页面加载完毕, 不一定及时得到数据
    func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        webEngine.parseJSPageData { [weak self] (data: [String: AnyObject]) in
            self?.delegate?.handleGlobalPageData?(data)
        }
        // 从H5中取得全局变量
        delay(0.5) {
            self.progressView.isHidden = true
        }
    }
    
    /// URL重定向
    func webView(_ webView: WKWebView, decidePolicyFor navigationAction: WKNavigationAction, decisionHandler: @escaping (WKNavigationActionPolicy) -> Void) {
        guard let url = navigationAction.request.url else {
            decisionHandler(.allow)
            return
        }
        let urlHost = url.host ?? ""
//        let dict = AppDelegate.navigation.visibleViewController?.getHostDictionary()
//        let selector = dict?[urlHost] as? String ?? ""
        if (url.scheme == URL_SCHEME) {
            //更美协议
            let urlStr = String(describing: url)
            let encodeUrlScheme = urlStr.addingPercentEncoding(withAllowedCharacters: .urlQueryAllowed) ?? ""
            let encodeUrl = URL(string: encodeUrlScheme)
            if encodeUrl == nil { return }
            GMRouter.sharedInstance().pushScheme(encodeUrlScheme)
            decisionHandler(.cancel)
            return
        } else if url.scheme == URL_HTTP_SCHEME || url.scheme == URL_HTTPS_SCHEME {
            //正常http 请求 或者https请求
            decisionHandler(.allow)
            return
        } else if url.scheme == "tel" {
            if #available(iOS 10.0, *) {
                UIApplication.shared.open(url, options: [:], completionHandler: nil)
            } else {
                UIApplication.shared.openURL(url)
            }
            decisionHandler(.allow)
            return
        } else {
            let urlHost = url.host ?? ""
            if !urlHost.isNonEmpty() {
                decisionHandler(.allow)
                return
            }
            let params = NSString(string: url.absoluteString).urlQueryToDictionary() ?? [:]
            if  self.delegate?.handleLinkTap?(url.absoluteString, host: urlHost, params: params as? [String: AnyObject]) != nil {
                decisionHandler(.cancel)
                return
            } else {
                decisionHandler(.allow)
                return
            }
        }
    }
    //跳转失败的时候调用
    public func webView(_ webView: WKWebView, didFail navigation: WKNavigation!, withError error: Error) {
         progressView.isHidden = true
        print(error)
    }
    // 内容加载失败时候调用
    public func webView(_ webView: WKWebView, didFailProvisionalNavigation navigation: WKNavigation!, withError error: Error) {
        progressView.isHidden = true
        print(error)
    }
    
    // 打开新窗口委托
    public func webView(_ webView: WKWebView, createWebViewWith configuration: WKWebViewConfiguration, for navigationAction: WKNavigationAction, windowFeatures: WKWindowFeatures) -> WKWebView? {
        if navigationAction.targetFrame?.isMainFrame == nil {
            webView.load(navigationAction.request)
        }
        return nil
    }
}

// MARK: - WKUIDelegate 不实现该代理方法 网页内调用弹窗时会抛出异常,导致程序崩溃
extension GMWebViewComponent: WKUIDelegate, WMPostInputViewDelegate {
    
    // 获取js 里面的提示
    public func webView(_ webView: WKWebView, runJavaScriptAlertPanelWithMessage message: String, initiatedByFrame frame: WKFrameInfo, completionHandler: @escaping () -> Void) {
        
        let alert = UIAlertController(title: "提示", message: message, preferredStyle: .alert)
        alert.addAction(UIAlertAction(title: "确定", style: .default, handler: { (_) -> Void in
            completionHandler()
        }))
        alert.addAction(UIAlertAction(title: "取消", style: .cancel, handler: { (_) -> Void in
            completionHandler()
        }))
        AppDelegate.visibleController.present(alert, animated: true, completion: nil)
    }
    
    // js 信息的交流
    public func webView(_ webView: WKWebView, runJavaScriptConfirmPanelWithMessage message: String, initiatedByFrame frame: WKFrameInfo, completionHandler: @escaping (Bool) -> Void) {
        
        let alert = UIAlertController(title: "提示", message: message, preferredStyle: .alert)
        alert.addAction(UIAlertAction(title: "确定", style: .default, handler: { (_) -> Void in
            completionHandler(true)
        }))
        alert.addAction(UIAlertAction(title: "取消", style: .cancel, handler: { (_) -> Void in
            completionHandler(false)
        }))
        AppDelegate.visibleController.present(alert, animated: true, completion: nil)
    }
    
    // 交互。可输入的文本。
    public func webView(_ webView: WKWebView, runJavaScriptTextInputPanelWithPrompt prompt: String, defaultText: String?, initiatedByFrame frame: WKFrameInfo, completionHandler: @escaping (String?) -> Void) {
        
        let alert = UIAlertController(title: prompt, message: defaultText, preferredStyle: .alert)
        
        alert.addTextField { (textField: UITextField) -> Void in
            textField.textColor = UIColor.red
        }
        alert.addAction(UIAlertAction(title: "确定", style: .default, handler: { (_) -> Void in
            completionHandler(alert.textFields![0].text!)
        }))
        AppDelegate.visibleController.present(alert, animated: true, completion: nil)
    }
    
    @objc(callPhone:) func callPhone(phone: String) {
        var phoneStr = phone
        if phone.contains("tel") {
            phoneStr = phone.replacingOccurrences(of: "\"", with: "")
        } else {
            phoneStr = "tel:\(phone)"
        }
        if #available(iOS 10.0, *) {
            UIApplication.shared.open(URL(string: phoneStr)!, options: [:], completionHandler: nil)
        } else {
            UIApplication.shared.openURL(URL(string: phoneStr)!)
        }
    }
    
    @objc(showConfirm:) func showConfirm(jsonStr: String) {
        let object = WMAlertParameterObject(string: jsonStr, error: nil)
        if object != nil {
            let alert = UIAlertController.showCustomAlert(withTitle: object!.title ?? "标题", message: object!.content ?? "内容")
            alert.addAction(object?.confirmText ?? "确定") {
                self.loadJsCode(jsCode: object?.confirmCallback ?? "")
            }
            
            alert.addAction(object?.cancelText ?? "取消") {
                self.loadJsCode(jsCode: object?.cancelCallback ?? "")
            }
        }
    }
    
    /**
     7715 以后统一弹起键盘事件
     
     @param jsonString 回调方法和占位文字
     */
    @objc(showInputView:) func showInputView(param: String) {
        let data = param.data(using: String.Encoding.utf8)
        if let dict = (try? JSONSerialization.jsonObject(with: data!, options: .mutableContainers)) as? NSDictionary {
            self.showInputDic = dict
            self.showInputView.isHidden = false
            // 帖子详情的全部评论回复需要限制字数
            if AppDelegate.visibleController is GMTractateDetailController  {
                self.showInputView.textMaxCount = 50
            }
            self.showInputView.clear()
            self.showInputView.placeHolder = String(describing: dict["placeholder"]!)
            self.showInputView.show()
        }
    }
    
    /// 弹起美分框
    @objc(showTaskAlert:) func showTaskAlert(param: String) {
        let data = param.data(using: String.Encoding.utf8)
        if let dict = (try? JSONSerialization.jsonObject(with: data!,
        options: .mutableContainers)) as? NSDictionary {
            if dict.allKeys.count > 0 {
                AppDelegate.shareInstance().showPointAlert(dict)
            }
        }
    }
    
    /// 未实名认证的code==70006，发送一个弹出认证页面的通知(前端判断70006时, 直接调用方法)
    @objc(realNameAuthentication) func realNameAuthentication() {
        NotificationCenter.default.post(name: Notification.Name(rawValue: PHONE_AUTHENTICATION), object: nil)
    }

    /// 回收键盘弹窗
    func inputViewWillCancel(_ inputView: WMPostInputView!) {
        self.showInputView.hide()
    }

    /// 键盘发送事件
    ///
    /// - Parameters:
    ///   - inputView: 弹窗
    ///   - text: 发送内容
    func inputView(_ inputView: WMPostInputView!, sendText text: String!) {
        let a = NSString(string: String(describing: self.showInputDic["callback"]!))
        let b = text.trimBothEnd() ?? ""
        self.showInputView.hide()
        self.showInputView.isHidden = true
        let jsonStr = "window.gm.pack.run('\(a)', '\(b)')"
        let result = NSString(string: jsonStr)
        self.webView.evaluateJavaScript(result as String, completionHandler: nil)
    }
    
    /// 弹起全部回复
    @objc(showPopupView:) func showPopupView(_ title: String) {
        let data = title.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: data!, options: .mutableContainers) as! NSDictionary
        fullUrl = NSString(string: String(describing: dict!["fullUrl"] ?? "")) as String
        let reply = NSString(string: String(describing: dict!["title"] ?? ""))
        initPopUpView(reply as String)
    }
    
    /// 全部回复框动画完成
    @objc(didCompletedAnimation) func didCompletedAnimation() {
        let jsonStr = "window.gm.pack.run('refreshData')"
        self.webView.evaluateJavaScript(jsonStr, completionHandler: nil)
    }
}

// MARK: - WKScriptMessageHandler 对外暴露的方法
extension GMWebViewComponent: WKScriptMessageHandler {
    
    func userContentController(_ userContentController: WKUserContentController, didReceive message: WKScriptMessage) {
        if let dict = message.body as? [String: AnyObject] {
            let method: String = dict["method"] as! String
            let param = dict["param"]
            // 带参数的情况
            if  param != nil {
                let sel = "\(method):"
                if clientH5Object.delegate != nil {
                    if clientH5Object.responds(to: Selector(sel)) {
                        clientH5Object.perform(Selector(sel), with: param)
                    } else {
                        if self.responds(to: Selector(sel)) {
                            self.perform(Selector(sel), with: param)
                        }
                    }
                } else {
                    if self.responds(to: Selector(sel)) {
                        self.perform(Selector(sel), with: param)
                    }
                }
                
            } else {
                let sel = "\(method)"
                if (clientH5Object.delegate != nil) {
                    if clientH5Object.responds(to: Selector(sel)) {
                        clientH5Object.perform(Selector(sel))
                    }
                } else {
                    if self.responds(to: Selector(sel)) {
                        self.perform(Selector(sel))
                    }
                }
            }
        }
    }

    func showCommentList(_ string: String) {
        self.delegate?.jsShowCommentList?(string)
    }
    
    @objc(showCounsellorCard:) func showCounsellorCard(_ string: String) {
        self.delegate?.showCounsellorCard?(string)
    }
    
    @objc(showAllCard) func showAllCard() {
           self.delegate?.showAllCard?()
       }
    
    @objc(jsObjShowShareView:) func jsObjShowShareView(with pageData: String) {
        if pageData.isEmpty {
            return
        }
        let data = pageData.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: data!, options: .mutableContainers) as! NSDictionary
        self.delegate?.webViewShareData!(dict!)
    }
    
    /// 数据加载完毕, 前端调用方法, 得到pagedata中数据
    @objc(diaryGlobaltLoaded:) func diaryGlobaltLoaded(_ pageData: String) {
        let Data = pageData.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary
        self.delegate?.globalPageData!(dict!)
    }
    
    // 机构详情
    @objc(globalDataLoaded:) func globalDataLoaded(_ pageData: String) {
        let Data = pageData.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary
        self.delegate?.globalDataLoaded!(dict!)
    }
    
    // 7770 帖子头部切换
    @objc(scrollSetHeader:) func scrollSetHeader(_ JSONString: String) {
        let Data = JSONString.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary
        self.delegate?.scrollSetHeader!(dict!)
    }
    
    // true:导航栏显示 false:导航栏隐藏
    @objc(controlTitleBarVisible:) func controlTitleBarVisible(_ pageData: String) {
        let Data = pageData.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary
        let show = dict?["show"] as? Bool
        self.delegate?.controlTitleBarVisible!(show ?? false)
    }
    
    // 是否登录:1登录 0未登录
    @objc(isUserLogin) func isUserLogin() -> Int {
        let isLogin = GMLoginManager.shareInstance().isVisitor ? 0 : 1
        let result = "window.gm.pack.run('isUserLoginCallback', '\(isLogin)')"
        self.webView.evaluateJavaScript(result as String, completionHandler: nil)
        return isLogin
    }
    
    @objc(jsPop:) func jsPop(_ isPop: Bool) {
        if isPop {
            DispatchQueue.main.async {
                _ = AppDelegate.navigation.popViewController(animated: true)
            }
        }
    }
    
    @objc(domain) func domain() -> String {
        return GMServerDomains.apiHost
    }
    
    @objc(showLoading) func showLoading() {
        DispatchQueue.main.async {
            AppDelegate.visibleController.showLoading("")
        }
    }
    
    @objc(hideLoading) func hideLoading() {
        DispatchQueue.main.async {
            AppDelegate.visibleController.hideLoading()
        }
    }
    
    @objc(playVideo:) func playVideo(_ JSONString: String) {
        //Alert
        if !JSONString.isNonEmpty() {
            AppDelegate.visibleController.toast("视频无法播放")
            return
        }
        
        let data = JSONString.data(using: String.Encoding.unicode)
        do {
            let dict = try JSONSerialization.jsonObject(with: data!, options: .allowFragments) as! JsonType
            let playFrom = dict["page_name"] as? String ?? ""
            let topicId = dict["topic_id"] as? Int ?? 0
            let businessId = dict["business_id"] as? Int ?? 0
            let cardType = dict["card_type"] as? String ?? ""
            let index = dict["index"] as? Int ?? 0
            let currentTime = dict["currentTime"] as? Float ?? 0.0
            let state = dict["state"] as? Int ?? 0

            let playBackView = GMPlayerView()
            playBackView.topicId = "\(topicId)"
            playBackView.from = playFrom
            playBackView.index = index
            playBackView.needSkipSeconds = CGFloat(currentTime)
            playBackView.playState = state

            // 埋点使用
            let video = GMVideoObject()
            video.businessId = "\(businessId)"
            video.pageName = playFrom
            video.cardType = cardType
            playBackView.video = video
            
            if let playUrl = dict["url"] as? String {
                playBackView.play(playUrl, animationRect: CGRect.zero)
            }
        } catch {
            debugLog("track event error")
        }
    }
    
    @objc(getAddressBook:) func getAddressBook(_ JSONString: String) {
        DispatchQueue.main.async {
            let manager = GMAddressManager()
            manager.getAddressBookAuthorization()
        }
    }
    
    @objc(chooseOneContactPerson:) func chooseOneContactPerson(_ key: String) {
        let manager = GMAddressManager()
        manager.getOneContactPersonBlock = { result in
            if result != nil {
                if let data = try? JSONSerialization.data(withJSONObject: result!, options: JSONSerialization.WritingOptions.init(rawValue: 0)) {
                    let jsParam = String(data: data, encoding: String.Encoding.utf8)
                    let jsonStr = "gm.util.setContactPerson('\(jsParam ?? "")')" //TODO 待调试
                    self.webView.evaluateJavaScript(jsonStr, completionHandler: nil)
                }
            }
           
        }
        manager.chooseContactPersonAddressBookJsonString()
    }
    
    @objc(share:type:) func share(shareDataString: String, type: String) {
//        showAle
    }
    
    @objc(shareFaceInfoImageMethod:) func shareFaceInfoImageMethod(key: String) {
        self.delegate?.shareFaceInfoImageMethod?(key)
    }
    
    // 人脸分析之后点击分享传给客户端图片
    @objc(shareSkinInfoImageMethod:) func shareSkinInfoImageMethod(key: String) {
        self.delegate?.shareSkinInfoImageMethod?(key)
    }
    
    // 人脸分析之后点击分享传给客户端图片
     @objc(shareResearchInfoImageMethod:) func shareResearchInfoImageMethod(key: String) {
         self.delegate?.shareResearchInfoImageMethod?(key)
     }
    
    @objc(shareBase64ImageMethod:) func shareBase64ImageMethod(key: String) {
        self.delegate?.shareBase64ImageMethod?(key)
    }
    
    @objc(videoDiagnoseComplaint:) func videoDiagnoseComplaint(urlData: String) {
        let Data = urlData.data(using: String.Encoding.utf8)
        guard let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary else { return }
        self.delegate?.videoDiagnoseComplaint?(dict)
    }
    @objc(viewEvaluate:) func viewEvaluate(jsonString: String) {
        self.delegate?.viewEvaluate?(jsonString)
    }
    @objc(viewComplaint:) func viewComplaint(jsonString: String) {
        self.delegate?.viewComplaint?(jsonString)
    }
    @objc(viewConfirm:) func viewConfirm(jsonString: String) {
        self.delegate?.viewConfirm?(jsonString)
    }
    @objc(showComplaint:) func showComplaint(jsonString: String) {
        self.delegate?.showComplaint?(jsonString)
    }
    @objc(changeAvatar) func changeAvatar() {
        self.delegate?.changeAvatar?()
    }
    
    @objc(jsControlBackToMethod:) func jsControlBackToMethod(key: String) {
        self.delegate?.jsControlBackToMethod?(key)
    }
    
    @objc(jsJumpToResearchPage:) func jsJumpToResearchPage(url: String) {
           self.delegate?.jsJumpToResearchPage?(url)
       }
    
    @objc(closeFaceLoading) func closeFaceLoading() {
        self.delegate?.closeFaceLoading?()
    }
    
    @objc(showVideoBasicInfo:) func showVideoBasicInfo(key: String) {
        self.delegate?.showVideoBasicInfo?(key)
    }
    
    @objc(getVideoPermission:) func getVideoPermission(_ pageData: String) {
        let Data = pageData.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary
        self.delegate?.getVideoPermission!(dict!)
    }
    
    @objc(showClientShadow:) func showClientShadow(_ pageData: String) {
        let Data = pageData.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary
        self.delegate?.showClientShadow?(dict!)
    }
    
    @objc(closeCurrentPage) func closeCurrentPage() {
        self.delegate?.closeCurrentPage?()
    }
    
    @objc(consultationUrl:) func consultationUrl(_ urlData: String) {
        let Data = urlData.data(using: String.Encoding.utf8)
        guard let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary else { return }
        self.delegate?.consultationUrl?(dict)
    }
    
    @objc(saveFaceVideo:) func saveFaceVideo(key: String) {
        self.delegate?.saveFaceVideo?(key)
    }
    
    @objc(playFaceVideo) func playFaceVideo() {
        self.delegate?.playFaceVideo?()
    }
    

    @objc(openBrowser:) func openBrowser(urlStr: String) {
        let alert = UIAlertController.showCustomAlert(withTitle: "提示", message: "你访问的网址将以外部浏览器打开，是否继续？")
        alert.addAction("否", actionHandler: nil)
        alert.addAction("是") {
            if let url = URL(string: urlStr) {
                if #available(iOS 10, *) {
                    UIApplication.shared.open(url, options: [:], completionHandler: nil)
                } else {
                    UIApplication.shared.openURL(url)
                }
            }
        }
    }
    
    @objc(jumpToLocationSettings) func jumpToLocationSettings() {
        GMLocationManager.jumpToSettings()
    }
    
    @objc(locationShowAlertIfNotAllowed) func locationShowAlertIfNotAllowed() {
        GMLocationManager.showAlertIfNotAllowed()
    }
    //把所有的js交互 鉴于实现代理 还是放在具体的业务中处理比较好
    @objc(diaryDetailShowNotificationAlert) func diaryDetailShowNotificationAlert() {
        //弹出通知提示页面
        AppDelegate.shareInstance().userIsAllowPush { (status) in
            let str = GMCache.fetchObject(atDocumentPathWithkey: kShowNotifyAlert) as? String ?? ""
            if !str.isNonEmpty() && !status {
                self.delegate?.diaryDetailControllerShowNotificationAlert!()
            }
        }
        
    }
    //  秒杀页面添加到系统日历事件 jsonString H5传来的的美购信息
    @objc(remindEvent:) func remindEvent(jsonString: String) {
        
        if let data = jsonString.data(using: String.Encoding.utf8) {
            
            if let json = try? JSONSerialization.jsonObject(with: data, options: JSONSerialization.ReadingOptions.init(rawValue: 1)) as? JsonType {
                let beginTime = json!["start_time"] as? Double ?? 0
                let endTime = json!["end_time"] as? Double ?? 0
                let title = json!["title"] as? String ?? ""
                let url = json!["url"] as? String ?? ""
                let serviceId = json!["service_id"] as? String ?? ""
                let isNotify = json!["notify"] as? Bool ?? false
                
                let manager = GMCalendarEventManager()
                manager.authorizationAllowed = { () in
                    let param = NSMutableDictionary()
                    param["service_id"] = serviceId
                    Phobos.track("activity_promotion_seckill_notice", attributes: (param as? JsonType ?? nil)!)
                    manager.addEvent(title, startDate: beginTime, endDate: endTime, serviceId: serviceId, url: url)
                    
                }
                
                if manager.checkAuthorized() {
                    if isNotify {
                        let param = NSMutableDictionary()
                        param["service_id"] = serviceId
                        Phobos.track("activity_promotion_seckill_notice", attributes: (param as? JsonType ?? nil)!)
                    } else {
                        manager.removeEvent(serviceId)
                    }
                }
            }
            
        }
       
    }

    // 保险回调
    @objc(insurancePurchase:) func insurancePurchase(_ hasBought: NSNumber) {
        self.delegate?.insurancePurchase!(hasBought.boolValue)
    }
    
    // 保险回调
    @objc(jsPageReachBottom:) func jsPageReachBottom(_ isScrollbottom: NSNumber) {
        self.delegate?.jsPageReachBottom!(isScrollbottom.boolValue)
    }
    
    @objc(sendMessage:body:) func sendMessage(phone: String, body: String) {
        if GMMessageController.canSendText() {
            let messageVC = GMMessageController()
            messageVC.recipients = [phone]
            messageVC.body = body
            messageVC.modalPresentationStyle = UIModalPresentationStyle.fullScreen
            AppDelegate.visibleController.present(messageVC, animated: true, completion: nil)
        } else {
            AppDelegate.navigation.toast("当前设备不支持发短信")
        }
    }
    
    @objc(setHeaderHeight:) func setHeaderHeight(height: String) {
        
    }
    
    @objc(setLocalStorage:value:) func setLocalStorage(key: String, value: String) {
        GMCache.storeObject(atDocumentPathWithkey: key, object: value as NSCoding)
    }
    
    @objc(getLocalStorage:) func getLocalStorage(key: String) {
        
        let cacheValue = GMCache.fetchObject(atDocumentPathWithkey: key) as? String ?? ""
        
        let str = "window.gm.pack.run('getLocalStorage','\(cacheValue)')"
        self.webView.evaluateJavaScript(str) { (object, error) in
    
        }
    }
    
    // 获取native本地公共参数
    @objc(nativeDataLoaded) func nativeDataLoaded() {
        let param = NSMutableDictionary(dictionary: NSDictionary.trackerPageParam(AppDelegate.visibleController))
        param["title_bar_height"] = (OCNavigationBar.barHeight)
        param["referrer_tab_name"] = AppDelegate.visibleController.referrerTabName
        if let data = try? JSONSerialization.data(withJSONObject: param, options: JSONSerialization.WritingOptions.init(rawValue: 0)) {
            if let jsParam = String(data: data, encoding: String.Encoding.utf8) {
                self.webView.evaluateJavaScript("window.gm.pack.run('setNativeDataLoaded','\(jsParam)')", completionHandler: nil)
            }
        }
    }
    
    @objc(inflateUserInfo) func inflateUserInfo() {
        if let str = self.delegate?.inflateUserInfo?() {
            self.webView.evaluateJavaScript("window.gm.pack.run('setInflateUserInfo','\(str)')", completionHandler: nil)
        }
    }
    
    @objc(logout) func logout() {
        GMLoginManager.shareInstance().doLogoutAndShowLoginView()
    }
    
    //TODO
    @objc(jsOpenAlbum:isPrivate:) func jsOpenAlbum(_ requestCode: String, isPrivate: Bool) {

    }
    
    @objc(trackEvent:) func trackEvent(_ JSONString: String) {
        let data = JSONString.data(using: String.Encoding.unicode)
        do {
            let dict = try JSONSerialization.jsonObject(with: data!, options: .allowFragments) as! JsonType
            let params = dict["params"]
            if params is String {
                let objectData = (params as! String).data(using: String.Encoding.unicode)
                let json = try JSONSerialization.jsonObject(with: objectData!, options: .mutableContainers)
                Phobos.track(dict["type"] as? String ?? "", attributes: json as! JsonType)
            } else {
                let params = dict["params"] as? JsonType
                if params != nil {
                    Phobos.track(dict["type"] as? String ?? "", attributes: (params ?? nil)! )
                }
            }
        } catch {
            debugLog("track event error")
        }
    }
    
    @objc(showNativeEmptyView) func showNativeEmptyView() {
        Phobos.track("on_click_button", attributes: ["page_name": AppDelegate.visibleController.pageName,                                                 "button_name": "click_reload",], sendNow: false)
        self.delegate?.showNativeEmptyView?()
    }
    
    /// h5 实时调取 native 方法
    @objc(onLineGetData:) func onLineGetData(_ pageData: String) {
        let Data = pageData.data(using: String.Encoding.utf8)
        guard let dict = try? JSONSerialization.jsonObject(with: Data!, options: .mutableContainers) as! NSDictionary else { return }
        self.delegate?.onLineGetData?(dict)
    }
    
    @objc(sharewithType:) func sharewithType(with pageData: String) {
        if pageData.isEmpty {
            return
        }
        let data = pageData.data(using: String.Encoding.utf8)
        let dict = try? JSONSerialization.jsonObject(with: data!, options: .mutableContainers) as! NSDictionary
        self.delegate?.jsSharewithType?(dict!)
    }
    
    // 跳转第三方APP
    @objc(skipToThirdApp:) func skipToThirdApp(_ JSONString: String) {
        let data = JSONString.data(using: String.Encoding.utf8)
        guard let dict = try? JSONSerialization.jsonObject(with: data!, options: .mutableContainers) as! NSDictionary else { return }
        
        let urlStr = dict["target_url"] as! String
        let url = NSURL.init(string: urlStr)! as URL
        if #available(iOS 10.0, *) {
            UIApplication.shared.open(url, options: [:], completionHandler: nil)
        } else {
            UIApplication.shared.openURL(url)
        }
    }
    
    // 判断是否开启定位
    @objc(isLocationEnable) func isLocationEnable() {
        // WKWebview不支持直接传值，需要调H5的方法来传值给H5
        self.webView.evaluateJavaScript("window.gm.pack.run('isLocationEnableCallback','\(GMLocationManager.hasOpenLocationService())')", completionHandler: nil)
    }
    
    // toast 弹窗
    @objc(showToast:) func showToast(_ JSONString: String) {
        let data = JSONString.data(using: String.Encoding.utf8)
        guard let dict = try? JSONSerialization.jsonObject(with: data!, options: .mutableContainers) as! NSDictionary else { return }
        let text = dict["text"] as! String
        if !text.isEmpty {
            AppDelegate.visibleController.toast(text)
        }
    }
    
    // 精准曝光
    @objc(hybridExposure:) func hybridExposure(_ JSONString: String) {
        let data = JSONString.data(using: String.Encoding.unicode)
        do {
            let dict = try JSONSerialization.jsonObject(with: data!, options: .allowFragments) as! JsonType
            Phobos.track("page_precise_exposure", attributes: dict, sendNow: true, currentAPI: GMExactExposureApi)
        } catch {
            debugLog("track event error")
        }
    }
}

// MARK: - 扩展WKProcessPool，使其变成单例，所有WKWebView共享Cookie数据
extension WKProcessPool {
  static var SharedProcessPool: WKProcessPool = {
    var sharePool = WKProcessPool()
    return sharePool
  }()
  
  class func sharedProcessPool() -> WKProcessPool {
    return SharedProcessPool
  }
}

