//
//  GMCommonViewController.m
//  GMBase
//
//  Created by Mikasa on 2019/3/28.
//

#import "GMListViewController.h"
#import "GMListViewModel.h"

@interface GMListViewController()
/** viewModel */
@property (nonatomic, strong) GMListViewModel *viewModel;

@end

@implementation GMListViewController
#pragma mark - init
- (void)initController {
    
    [super initController];
    self.pageType = GMPageTypeTableView;
    self.viewModel = [GMListViewModel new];
}

#pragma mark - View LifeCycle
- (void)viewDidLoad {
    [super viewDidLoad];
    
    if (self.viewModel.immediateLoad) {
        [self loadRemoteData];
    }
}

#pragma mark - SubView
// 添加子View
- (void)setupSubView {
    
    [super setupSubView];
    if (self.pageType == GMPageTypeTableView) {
        
        UITableView *tableView = [UITableView new];
        tableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain];
        tableView.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        tableView.delegate = self;
        tableView.dataSource = self;
        tableView.rowHeight = UITableViewAutomaticDimension;
        tableView.estimatedRowHeight = 80;
        tableView.sectionHeaderHeight = UITableViewAutomaticDimension;
        tableView.sectionFooterHeight = UITableViewAutomaticDimension;
        [tableView registerCell:[UITableViewCell class]];
        tableView.backgroundColor = [UIColor clearColor];
        if(@available(iOS 11.0, *)) {
            tableView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
        }
        __weak __typeof(self)weakSelf = self;
        tableView.mj_header = [GMRefreshHeader headerWithRefreshingBlock:^{
            [weakSelf headerRefresh];
        }];
        tableView.mj_footer = [GMRefreshFooter footerWithRefreshingBlock:^{
            [weakSelf footerRefresh];
        }];
        self.tableView = tableView;
        [self.view addSubview:self.tableView];
        
    } else if(self.pageType == GMPageTypeTableView) {
        
        UICollectionView *collectionView = [[UICollectionView alloc] initWithFrame:self.view.bounds collectionViewLayout:self.collectionViewLayout];
        collectionView.backgroundColor = [UIColor clearColor];
        collectionView.delegate = self;
        collectionView.alwaysBounceVertical = YES;
        collectionView.dataSource = self;
        [collectionView registerCell:[UICollectionViewCell class]];
        __weak __typeof(self)weakSelf = self;
        collectionView.mj_header = [GMRefreshHeader headerWithRefreshingBlock:^{
            [weakSelf headerRefresh];
        }];
        collectionView.mj_footer = [GMRefreshFooter footerWithRefreshingBlock:^{
            [weakSelf footerRefresh];
        }];
        self.collectionView = collectionView;
        [self.view addSubview:self.collectionView];
    }
}

// 布局子View
- (void)layoutSubView {
    CGFloat top = 0;
    if ([self.parentViewController isKindOfClass:[UINavigationController class]]) {
        top = OCNavigationBar.barHeight;
    }
    __weak __typeof(self)weakSelf = self;
    if (self.tableView.superview) {
        
        [_tableView mas_makeConstraints:^(MASConstraintMaker *make) {
            //            make.left.equalTo(weakSelf.view.mas_left);
            //            make.right.equalTo(weakSelf.view.mas_right);
            //            make.top.mas_equalTo(top);
            //            make.bottom.mas_equalTo(0);
            make.edges.equalTo(weakSelf.view).insets(UIEdgeInsetsMake(top, 0, 0, 0));
        }];
    }
    
    if (self.collectionView.superview) {
        [_collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(weakSelf.view).insets(UIEdgeInsetsMake(top, 0, 0, 0));
        }];
    }
}

#pragma mark - Remote Data
- (void)reloadDateRefresh {
    
    [self.viewModel clearAllData];
    [self loadRemoteData];
}

- (void)loadRemoteData {
    
    self.reloadSelector = NSSelectorFromString(@"loadRemoteData");
    __weak __typeof(self)weakSelf = self;
    [self.viewModel excuteFetchDataSuccessBlock:^(id responseObject) {
        
        [weakSelf updateUIWithSuccess:YES];
        
    } failBlock:^(NSString *message) {
        
        [weakSelf updateUIWithSuccess:NO];
        
    }];
}

- (void)headerRefresh {
    [self.viewModel handleHeaderRefreshing];
    [self loadRemoteData];
}

- (void)footerRefresh {
    
    [self.viewModel handleFooterRereshing];
    [self loadRemoteData];
}

- (void)updateUIWithSuccess:(BOOL)success {
    
    [self hideLoading];
    
    // 判断当前dataArray是否有内容，防止第二页请求失败或者为空时，也把之前数据给遮盖了
    if (self.viewModel.dataArray == 0) {
        [self showEmptyView:success?GMEmptyViewTypeEmpty:GMEmptyViewTypeException];
    } else {
        // 是否需要在结束刷新没有更多数据时End掉
        if (self.viewModel.needEndRefreshNoMoreData) {
            
            // page分页模式 当前获取到的数量少于self.viewModel.count * self.viewModel.page,隐藏footer
            BOOL hiddenFooterRefresh = NO;
            if (self.viewModel.perPageType == GMPerPageTypePage &&
                (self.viewModel.dataArray.count < self.viewModel.count * self.viewModel.page)) {
                hiddenFooterRefresh = YES;
            }
            
            // startNum分页模式 当startNum + 过滤掉的deleteCount 数量少于self.viewModel.count * self.viewModel.page,隐藏footer
            if (self.viewModel.perPageType == GMPerPageTypeStartNum &&
                ((self.viewModel.startNum + self.viewModel.deleteCount) < self.viewModel.count * self.viewModel.page)) {
                hiddenFooterRefresh = YES;
            }
            [self currentSrollView].mj_footer.hidden = hiddenFooterRefresh;
        }
    }
    UIScrollView *scrollView = [self currentSrollView];
    
    // 关掉动画
    [scrollView.mj_header endRefreshing];
    [scrollView.mj_footer endRefreshing];
    if (self.tableView.superview) {
        [self.tableView reloadData];
    } else if (self.collectionView.superview) {
        [self.collectionView reloadData];
    }
    
}

- (UIScrollView *)currentSrollView {
    
    if (self.pageType == GMPageTypeTableView) {
        return self.tableView;
    } else if (self.pageType == GMPageTypeCollectionView){
        return self.collectionView;
    }
    return [UIScrollView new];
}

#pragma mark - TableView Delegate
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    //返回行数
    return [self.viewModel.dataArray count];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:[tableView indexPathForSelectedRow] animated:YES];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([UITableViewCell class]) forIndexPath:indexPath];
    return cell;
}

#pragma mark - UICollectionViewDelegate and UICollectionViewDataSource

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section{
    return self.viewModel.dataArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath{
    UICollectionViewCell *cell = [collectionView dequeueCell:[UICollectionViewCell class] forIndexPath:indexPath];
    return cell;
}

#pragma mark - lazy Loading
/*
- (UITableView *)tableView {
    if (!_tableView) {
        UITableView *tableView = [UITableView new];
        tableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain];
        tableView.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        tableView.delegate = self;
        tableView.dataSource = self;
        tableView.rowHeight = UITableViewAutomaticDimension;
        tableView.estimatedRowHeight = 80;
        tableView.sectionHeaderHeight = UITableViewAutomaticDimension;
        tableView.sectionFooterHeight = UITableViewAutomaticDimension;
        tableView.backgroundColor = [UIColor clearColor];
        if(@available(iOS 11.0, *)) {
            tableView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
        }
        __weak __typeof(self)weakSelf = self;
        tableView.mj_header = [GMRefreshHeader headerWithRefreshingBlock:^{
            [weakSelf headerRefresh];
        }];
        tableView.mj_footer = [GMRefreshFooter footerWithRefreshingBlock:^{
            [weakSelf footerRefresh];
        }];
        _tableView = tableView;
    }
    return _tableView;
}

- (UICollectionView *)collectionView {
    if (!_collectionView) {
        UICollectionView *collectionView = [[UICollectionView alloc] initWithFrame:self.view.bounds collectionViewLayout:self.collectionViewLayout];
        collectionView.backgroundColor = [UIColor clearColor];
        collectionView.delegate = self;
        collectionView.alwaysBounceVertical = YES;
        collectionView.dataSource = self;
        __weak __typeof(self)weakSelf = self;
        collectionView.mj_header = [GMRefreshHeader headerWithRefreshingBlock:^{
            [weakSelf headerRefresh];
        }];
        collectionView.mj_footer = [GMRefreshFooter footerWithRefreshingBlock:^{
            [weakSelf footerRefresh];
        }];
        _collectionView = collectionView;
    }
    return _collectionView;
}
*/
- (UICollectionViewLayout *)collectionViewLayout {
    if (!_collectionViewLayout) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
        layout.minimumLineSpacing = 3;
        layout.minimumInteritemSpacing = 3;
        layout.itemSize = CGSizeMake(50, 50);
        _collectionViewLayout = layout;
    }
    return _collectionViewLayout;
}

@end
