//
//  GMViewController.h
//  GMBase
//
//  Created by Mikasa on 2019/3/27.
//

#import <GMKit/GMKit-umbrella.h>
#import "GMViewModel.h"
#import "OCNavigationBar.h"
#import "GMPageViewProtocol.h"
//@import GMHud;
#import <GMHud/GMHud-umbrella.h>


@interface GMViewController : UIViewController<GMPageViewProtocol>

/** 导航 */
@property (nonatomic, strong) OCNavigationBar *navigationBar;

/** 默认值为NO, 表示导航栏自动被WMBaseViewController管理, 永远在所有的view最上方。 */
@property (nonatomic, assign) BOOL controlNavigationByYou;

/** 点击重新加载视图调用方法 */
@property (nonatomic, assign) SEL reloadSelector;

/** 空/异常页面 默认展示空页面*/
@property (nonatomic, strong) GMEmptyView *emptyView;

@property (nonatomic, assign) GMPageType pageType;

/**
 @brief  因为controller会有initWithCoder，init，initWithNib三种方式，为了避免子类代码的疏忽导致父类自定义init内容没有覆盖到，所以统一使用initController方法。需要调用super
 页面埋点类最好都放在此处设置
 */
- (void)initController __attribute__((objc_requires_super));

/**
 展示空/异常页面
 @param type 页面类型
 */
- (void)showEmptyView:(GMEmptyViewType)type;

/** 隐藏空页面 */
- (void)hideEmptyView;

/** 点击空页面调用方法（reloadSelector）*/
- (void)emptyViewDidClickReload;

@end

