//
//  GMViewController.m
//  GMBase
//
//  Created by Mikasa on 2019/3/27.
//

#import "GMViewController.h"

@interface GMViewController ()<GMEmptyViewDelegate>

@end

@implementation GMViewController

#pragma mark - init
- (instancetype)init {
    // 在init方法里调用initWithNibName:bundle，保证了WMBaseViewController里的initWithNibName不会再次被调用，也就是保证了initController方法不会被调用两次
    self = [super initWithNibName:nil bundle:nil];
    if (self) {
        [self initController];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)coder {
    self = [super initWithCoder:coder];
    if (self) {
        [self initController];
    }
    return self;
}

- (instancetype)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    [self initController];
    return self;
}

- (instancetype)initWithPageType:(GMPageType)pageType {
    if (self = [super init]) {
        self.pageType = pageType;
        [self initController];
    }
    return self;
}

- (void)initController {
    
    self.controlNavigationByYou = NO;
    self.pageType = GMPageTypeNomal;
    
    [self addPageObserver];
}

- (void)addPageObserver {}

- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

#pragma mark - View LifeCycle
- (void)viewDidLoad {
    
    [super viewDidLoad];
    
    self.edgesForExtendedLayout = UIRectEdgeNone;
    self.view.backgroundColor = [GMPageProfileModel shareInstance].bgPageColor;
    
    // 添加子View
    [self setupSubView];
}

- (void)setupSubView {}

- (void)layoutSubView {}

- (void)updateLayoutSubView {}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    
    // 保证navigationBar 始终处于最上方位置
    if (!self.controlNavigationByYou) {
        [self.view bringSubviewToFront:self.navigationBar];
    }
}

- (void)didMoveToParentViewController:(UIViewController *)parent {
    [super didMoveToParentViewController:parent];
    
    // 作为childController使用，但不是被push到 UINavigationController时，隐藏导航栏
    if (parent != nil && ![parent isKindOfClass:[UINavigationController class]]) {
        self.navigationBar.hidden = YES;
    }
}

#pragma mark - Empty View
- (void)showEmptyView:(GMEmptyViewType)type {
    
    self.emptyView.hidden = NO;
    self.emptyView.type = type;
    [self.view bringSubviewToFront:self.emptyView];
}

- (void)hideEmptyView {
    self.emptyView.hidden = YES;
}

- (void)emptyViewDidClickReload {
    
    [self hideEmptyView];
    if (self.reloadSelector && [self respondsToSelector:self.reloadSelector]) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Warc-performSelector-leaks"
        [self performSelector:self.reloadSelector];
#pragma clang diagnostic pop
    }
}

#pragma mark - OCNavigationBar
- (void)hideLeftButtonForRootController {
    if (self.navigationController.viewControllers.count == 1) {
        _navigationBar.leftButton.hidden = YES;
    }
}

- (void)setTitle:(NSString *)title {
    [super setTitle:title];
    self.navigationBar.title = title;
}

#pragma mark - OCNavigationBarDelegate
- (void)nearRightButtonClicked:(OCNavigationBarButton *)button {}
- (void)rightButtonClicked:(OCNavigationBarButton *)button {}
- (void)backAction:(OCNavigationBarButton *)button {
    if ([self.parentViewController isKindOfClass:[UINavigationController class]]) {
        UINavigationController *navigation = (UINavigationController *)self.parentViewController;
        NSArray *controllers = navigation.viewControllers;
        if (self.presentingViewController && controllers.count == 1) {
            [self dismissViewControllerAnimated:YES completion:nil];
        }else{
            [self.navigationController popViewControllerAnimated:YES];
        }
    }else{
        [self dismissViewControllerAnimated:YES completion:nil];
    }
}

#pragma mark - Private Method
- (UIStatusBarStyle)preferredStatusBarStyle{
    return UIStatusBarStyleDefault;
}


#pragma mark - Lazy Loading
- (OCNavigationBar *)navigationBar {
    if (!_navigationBar) {
        OCNavigationBar *navigationBar = [OCNavigationBar new];
        _navigationBar = navigationBar;
    }
    if (!_navigationBar.superview) {
        [self.view addSubview:_navigationBar];
    }
    [_navigationBar mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(OCNavigationBar.barHeight);
    }];
    return _navigationBar;
}

- (GMEmptyView *)emptyView {
    if (!_emptyView) {
        GMEmptyView *emptyView = [GMEmptyView new];
        emptyView.hidden = YES;
        emptyView.delegate = self;
        emptyView.type = GMEmptyViewTypeEmpty;
        _emptyView = emptyView;
    }
    if (!_emptyView.superview) {
        [self.view addSubview:_emptyView];
    }
    CGFloat emptyViewTop = [self.parentViewController isKindOfClass:[UINavigationController class]]?OCNavigationBar.statusBarHeight:0;
    [_emptyView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
        make.top.mas_equalTo(emptyViewTop);
    }];
    return _emptyView;
}

@end
