//
//  GMListViewModel.h
//  GMBase
//
//  Created by Mikasa on 2019/3/28.
//

#import <GMNetService/WMNetService.h>
#import "GMViewModel.h"
#import <GMNetworking/GMNetworking-Swift.h>

//@import GMNetworking;

@interface GMListViewModel : GMViewModel

/** 是否需要下拉刷新 默认YES*/
@property (nonatomic, assign) BOOL needHeaderRefresh;
/** 是否上拉加载更多 默认YES*/
@property (nonatomic, assign) BOOL needFooterRefresh;
/** 是否需要结束掉上拉加载在没有更多数据的时候 默认YES*/
@property (nonatomic, assign) BOOL needEndRefreshNoMoreData;
/** 是否需要立即加载数据 默认YES*/
@property (nonatomic, assign) BOOL immediateLoad;
/** 分页类型 默认GMPerPageTypeStartNum */
@property (nonatomic, assign) GMPerPageType perPageType;
/** 请求uri */
@property (nonatomic, copy) NSString *uri;
/** 请求httpMethod */
@property (nonatomic, assign) GMHTTPMethod httpMethod;
/** 请求参数 */
@property (nonatomic, strong) NSMutableDictionary *params;

/** @brief  获取http数据分页第一页起始位置，默认为0，下一页为startNum+每页的数据条数（默认为10） */
@property (nonatomic,assign) NSInteger startNum;

/** @brief  获取http数据，每页获取数据（默认为10） */
@property (nonatomic,assign) NSInteger count;

/** @brief  因本地去重复被删掉的数据count */
@property (nonatomic, assign) NSInteger deleteCount;

/** @brief  获取http数据，列表总数量） */
@property (nonatomic, assign) NSInteger totalCount;

/** @brief  获取http数据，当前页码（默认为1）*/
@property (nonatomic, assign) NSInteger page;

/** @brief  获取到的列表数据 */
@property (nonatomic, strong) NSMutableArray *dataArray;

// 清理所有数据
- (void)clearAllData;

- (void)excuteFetchDataSuccessBlock:(HttpSuccessBlock)successBlock
                          failBlock:(HttpFailedBlock)failBlock;

- (void)handleFooterRereshing;

- (void)handleHeaderRefreshing;
@end

