//
//  GMListViewModel.m
//  GMBase
//
//  Created by Mikasa on 2019/3/28.
//

#import "GMListViewModel.h"
//#import <GMNetworking/GMNetworking-umbrella.h>
//@import GMNetService

@implementation GMListViewModel

- (instancetype)init {
    if (self = [super init]) {
        
        self.page = 1;
        self.count = 10;
        self.startNum = 0;
        self.deleteCount = 0;
        self.totalCount = 0;
        self.needEndRefreshNoMoreData = YES;
        self.immediateLoad = YES;
        self.needFooterRefresh = YES;
        self.needHeaderRefresh = YES;
        self.httpMethod = GMHTTPMethodGet;
        // 默认取配置项,用于全局更改
        self.perPageType = [GMPageProfileModel shareInstance].perPageType;
        self.dataArray = [NSMutableArray array];
        self.params = [NSMutableDictionary dictionary];
        self.uri = @"";
    }
    return self;
}

#pragma mark - buildParams
- (void)buildParams {
    
    [self.params setObject:@(self.count) forKey:@"count"];
    if (self.perPageType == GMPerPageTypeStartNum) {
        [self.params setObject:@(self.startNum) forKey:@"start_num"];
    } else if (self.perPageType == GMPerPageTypePage) {
        [self.params setObject:@(self.page) forKey:@"page"];
    }
}

#pragma mark - HeaderFooterRereshing
- (void)handleHeaderRefreshing {
    self.page = 1;
    [self.dataArray removeAllObjects];
    [self fetchRemoteData];
}

- (void) handleFooterRereshing{
    self.page ++;
    self.startNum = self.deleteCount + self.dataArray.count;
    [self fetchRemoteData];
}

// 获取远程数据
- (void)fetchRemoteData {}

#pragma mark - Fetch RemoteData
- (void)excuteFetchDataSuccessBlock:(HttpSuccessBlock)successBlock
                          failBlock:(HttpFailedBlock)failBlock {
    
    [self buildParams];
    
    __weak __typeof(self)weakSelf = self;
    
    [GMNetworking requestOCWithApi:self.uri method:GMHTTPMethodGet parameters:self.params completion:^(GMResponseOC *responseObject) {

        if (responseObject.isSuccess) {

            if([responseObject isKindOfClass:[NSDictionary class]]) {
                NSDictionary *dict = (NSDictionary *)responseObject;
                NSInteger code = [[dict objectForKey:@"error"] integerValue];
                if (code == APIStatusCodeFailed) {
                    [weakSelf dealRemoteFailData];
                    if (failBlock) {
                        failBlock(responseObject.message);
                    }
                }
            } else {
                [weakSelf dealRemoteSuccessData:responseObject.data];
                if (successBlock) {
                    successBlock(responseObject.data);
                }
            }
        } else {
            [weakSelf dealRemoteFailData];
            if (failBlock) {
                failBlock(responseObject.message);
            }
        }
    }];
}

// 清理所有数据
- (void)clearAllData {
    
    self.deleteCount = 0;
    self.totalCount = 0;
    [self.dataArray removeAllObjects];
}

#pragma mark - Fetch RemoteData
- (void)dealRemoteSuccessData:(id)responseObject {}

- (void)dealRemoteFailData {
    
    if (self.page != 1 && self.startNum != 0 ) {
        self.page--;
        self.startNum = self.startNum - self.dataArray.count;
    }
}
@end
