//
//  GMPageViewProtocol.h
//  GMBase
//
//  Created by Mikasa on 2019/3/28.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, GMPageType) {
    GMPageTypeNomal             = 0,// 普通Viewtroller
    GMPageTypeTableView         = 1,// 拥有一个TableView Viewtroller
    GMPageTypeCollectionView    = 2 // 拥有一个CollectView Viewtroller
};

@protocol GMPageViewProtocol <NSObject>

/**
 初始化获取一个ViewController
 
 @param pageType  三种类型页面
 
 GMPageTypeNomal            : 普通Viewtroller
 GMPageTypeTableView        : 拥有一个TableView Viewtroller
 GMPageTypeCollectionView   : 拥有一个CollectView Viewtroller
 
 @return ViewController
 */
- (instancetype)initWithPageType:(GMPageType)pageType;

@optional
/**
 初始化获取一个ViewController
 
 @param viewModel viewModel
 @return ViewController
 */
- (instancetype)initWithViewModel:(GMViewModel *)viewModel;
/**
 初始化获取一个ViewController
 
 @param viewModel viewModel
 @param pageType  三种类型页面
 
 GMPageTypeNomal            : 普通Viewtroller
 GMPageTypeTableView        : 拥有一个TableView Viewtroller
 GMPageTypeCollectionView   : 拥有一个CollectView Viewtroller
 
 @return ViewController
 */
- (instancetype)initWithViewModel:(GMViewModel *)viewModel pageType:(GMPageType)pageType;

- (void)addPageObserver;

#pragma mark - Setup SubView
/** 添加子View */
- (void)setupSubView;

/** 布局子View */
- (void)layoutSubView;

/** 更新布局子View */
- (void)updateLayoutSubView;

/** 获取当前页面listView */
- (UIScrollView *)currentSrollView;

@end

@protocol GMPageListViewProtocol <NSObject>
#pragma mark - DataRefresh

/** 下拉刷新 */
- (void)headerRefresh;

/** 上拉加载*/
- (void)footerRefresh;

#pragma mark - Update UI
/** 获取数据后更新UI */

/**
 获取数据完成后更新UI

 @param success 是否成功获取数据
 */
- (void)updateUIWithSuccess:(BOOL)success;

#pragma mark - DataRefresh

/** 加载远程数据 */
- (void)loadRemoteData;

/** 重新加载数据（清理当前数据+初始化请求） */
- (void)reloadDateRefresh;

@end
