//
//  GMServiceProtocal.h
//  GMBase
//
//  Created by Mikasa on 2019/3/28.
//

#import "GMService.h"
//@import GMNetworking;
#import <GMNetworking/GMNetworking-Swift.h>

@protocol GMServiceProtocol <NSObject>

@property (nonatomic, strong) GMService *service;

/**
 *  @brief  构造Http请求的params的值，如果不构造，则params为nil
 */
- (void)buildParams;

@end

@protocol GMDataDealProtocol <NSObject>

/**
 *  @brief  处理远程数据成功获取后的处理
 *
 *  @param responseObject 远程获取的数据
 */
- (void)dealRemoteSuccessData:(id)responseObject;

/**
 *  @brief  处理远程数据失败获取后的处理
 */
- (void)dealRemoteFailData:(NSString *)message;

/**
 *  @author wangyang, 15-11-25 15:11:53
 *
 *  @brief  解析去重数组，并且添加到 self.dataArray 中
 *  @param array JSON 中的 Object 数组，也可以是转成 Model 的 array
 *  @param buildBlock 用这个把 dic 转为 Model 再返回。可以为NULL。为NULL时一般用于 array 已经是转成 Model 的 array
 *  @since 5.6.0
 */
- (void)deduplicationForArray:(NSArray *)array buildModelBlock:(id (^)(NSDictionary *dic))buildBlock;
/**
 *  @author wangyang, 16-01-14 16:01:53
 *
 *  @brief 将数组去重，然后返回组织好数据的新model数组
 *  @param array      待去重的数据
 *  @param buildBlock 解析器
 *  @return 使用解析器组织好Model的数据
 *  @since 5.8.0
 */
- (NSArray *)deduplicationArrayFromArray:(NSArray *)array buildModelBlock:(id (^)(NSDictionary *dic))buildBlock;

@end
