//
//  GMNetConstant.h
//  Pods
//
//  Created by wangyang on 16/5/13.
//
//

#ifndef GMNetConstant_h
#define GMNetConstant_h


/** @brief API状态枚举 */
/** @brief API状态枚举 */
typedef NS_ENUM(NSInteger, APIStatusCode)  {
    APIStatusCodeSuccess = 0,
    APIStatusCodeEmpty = 1,
    APIStatusCodeFailed = 2
};

/** @brief Http状态枚举 */
typedef NS_ENUM(NSInteger, HttpStatusCode)  {
    HttpStatusCodeSuccess = 200,
    HttpStatusCodeError = 500,
    HttpStatusCodeUnauthorized = 403,
    HttpStatusCodeAuthentication = 70006   //实名认证
};

/** @brief Http方法枚举 */
typedef NS_ENUM(NSInteger, HttpMethod)  {
    HttpMethodGet = 0,
    HttpMethodPost,
    HttpMethodPut,
    HttpMethodDelete,
    HttpMethodPatch
};

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnullability-completeness"

/** @brief Http返回结果Block */
typedef void(^HttpSuccessBlock)(id responseObject);
typedef void(^HttpFailedBlock)(NSString *message);

typedef void (^ResultFailed) (NSString * _Nullable message);

#endif /* GMNetConstant_h */
