//
//  CacheService.h
//  Gengmei
//
//  Created by Thierry on 1/5/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>
//#import <TMCache.h>
#import "WMDocumentCache.h"

typedef NS_ENUM(NSUInteger, WMCacheMethod) {
    WMCacheDiskMethod = 1,
    WMCacheMemoryMethod
    
};

@interface WMCacheService : NSObject
@property (nonatomic,strong) NSString * urlCommonString;
+ (instancetype )sharedInstance;

/**
 *  @brief  异步磁盘读写操作
 */

/***  @brief  由对应的键获取对应的缓存数据*/
- (void)storeObjectAtDiskWithkey:(NSString *)key
                          object:(id <NSCoding>)object
                           block:(TMDiskCacheObjectBlock)block;
/***  @brief  给特定的键，标记缓存数据并缓存*/
- (void)fetchObjectAtDiskWithkey:(NSString *)key
                           block:(TMDiskCacheObjectBlock)block;
/***  @brief  删除特定的键,对应的缓存数据*/
- (void)removeObjectAtDiskWithkey:(NSString *)key
                            block:(TMDiskCacheObjectBlock)block;
/***  @brief  清空所有的缓存数据*/
- (void)removeAllObjectsAtDiskWithBlock:(TMDiskCacheBlock)block;


/**
 *  @brief  同步磁盘读写操作
 */

/***  @brief  由对应的键获取对应的缓存数据*/
- (void)storeObjectAtDiskWithkey:(NSString *)key
                          object:(id <NSCoding>)object;
/***  @brief  给特定的键，标记缓存数据并缓存*/
- (id)fetchObjectAtDiskWithkey:(NSString *)key;
/***  @brief  删除特定的键,对应的缓存数据*/
- (void)removeObjectAtDiskWithkey:(NSString *)key;
/***  @brief  清空所有的缓存数据*/
- (void)removeAllObjectsAtDisk;




/**
 *  @brief  异步内存读写操作
 */
/***  @brief  由对应的键获取对应的缓存数据*/
- (void)storeObjectAtMemoryWithkey:(NSString *)key
                          object:(id <NSCoding>)object
                           block:(TMMemoryCacheObjectBlock)block;
/***  @brief  给特定的键，标记缓存数据并缓存*/
- (void)fetchObjectAtMemoryWithkey:(NSString *)key
                           block:(TMMemoryCacheObjectBlock)block;
/***  @brief  删除特定的键,对应的缓存数据*/
- (void)removeObjectAtMemoryWithkey:(NSString *)key
                            block:(TMMemoryCacheObjectBlock)block;
/***  @brief  清空所有的缓存数据*/
- (void)removeAllObjectsAtMemoryWithBlock:(TMMemoryCacheBlock)block;


/**
 *  @brief  同步内存读写操作
 */
/***  @brief  由对应的键获取对应的缓存数据*/
- (void)storeObjectAtMemoryWithkey:(NSString *)key
                            object:(id)object;
/***  @brief  给特定的键，标记缓存数据并缓存*/
- (id)fetchObjectAtMemoryWithkey:(NSString *)key;
/***  @brief  删除特定的键,对应的缓存数据*/
- (void)removeObjectAtMemoryWithkey:(NSString *)key;
/***  @brief  清空所有的缓存数据*/
- (void)removeAllObjectsAtMemory;


#pragma mark - 这里将数据缓存到Ducument目录下


/**
 *  @brief  异步磁盘读写操作
 */
- (void)storeObjectAtDucmentPathWithkey:(NSString *)key
                          object:(id <NSCoding>)object
                           block:(TMDiskCacheObjectBlock)block;
- (void)fetchObjectAtDucmentPathWithkey:(NSString *)key
                           block:(TMDiskCacheObjectBlock)block;
- (void)removeObjectAtDucmentPathWithkey:(NSString *)key
                            block:(TMDiskCacheObjectBlock)block;
- (void)removeAllObjectsAtDucmentPathWithBlock:(TMDiskCacheBlock)block;

/**
 *  @brief  同步内存读写操作
 */
- (void)storeObjectAtDucmentPathWithkey:(NSString *)key
                          object:(id <NSCoding>)object;
- (id)fetchObjectAtDucmentPathWithkey:(NSString *)key;
- (void)removeObjectAtDucmentPathWithkey:(NSString *)key;
- (void)removeAllObjectsAtDucmentPath;


@end
