//
//  Phobos.h
//  GengmeiDoctor
//  Data Statistic Client For Mars
//  Created by Thierry on 16/1/26.
//  Copyright © 2016年 wanmeizhensuo. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface Phobos : NSObject

/**
 *  @brief 开启Phobos统计,默认以BATCH方式发送log.
 *
 *  @param appName
 *  @param channelId
 *
 *  @return
 *
 *  @since 0.0.1
 */
+ (Phobos *)clientWithAppName:(NSString *)appName channelId:(NSString *)channelId;

+ (instancetype)sharedClient;

+ (void)setSharedClient:(Phobos *)client;


/**
 *  @brief 设置是否打印sdk的log信息,默认不开启
 *
 *  @param value 设置为YES,phobos SDK 会输出log信息,记得release产品时要设置回NO.
 *
 *  @since 0.0.1
 */
- (void)setLogEnabled:(BOOL)value;

/**
 *  @brief 设置当前登录用户的ID，如果没有默认为@""
 *
 *  @param userId
 *
 *  @since 0.0.2
 */
- (void)setUserId:(NSInteger)userId;

/**
 *  @brief 自定义事件,数量统计.
 *
 *  @param eventId 事件Id
 *  @attributes 参数
 *  @sendNow 是否实时发送，默认为NO
 *
 *  @since 0.0.1
 */
- (void)track:(NSString *)eventId;
- (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes;
- (void)track:(NSString *)eventId attributes:(NSDictionary *)attributes sendNow:(BOOL)sendNow;
/**
 *  @author 翟国钧, 16-02-03 16:02:30
 *
 *  @brief H5调用的埋点方法
 *
 *  @param jsonString h5传过来的参数
 *
 *  @since 0.0.1
 */
- (void)trackJsEvent:(NSString *)jsonString;


@end
