//
//  GMPhotoTest.m
//  GMPhobos
//
//  Created by Thierry on 16/1/28.
//  Copyright © 2016年 licong. All rights reserved.
//

#import <XCTest/XCTest.h>
#import "Phobos.h"
#import "WMCacheService.h"

#define PhobosCacheKey        @"PhobosCacheKey"

NSString      *const MockAppName      = @"gengmei";
NSString      *const MockChannelId    = @"AppStore";
NSString      *const MockEventId      = @"eventId";
NSInteger     const  MockUserId       = 1;

@interface GMPhotoTest : XCTestCase
@property Phobos *client;
@property WMCacheService *cache;
@end

@implementation GMPhotoTest

- (void)setUp {
    [super setUp];
    _client = [Phobos clientWithAppName:MockAppName channelId:MockChannelId];
    [Phobos setSharedClient:_client];
    
    _cache = [WMCacheService sharedInstance];
}

- (void)tearDown {
    // Put teardown code here. This method is called after the invocation of each test method in the class.
    [super tearDown];
    [_cache removeObjectAtDiskWithkey:PhobosCacheKey];
}

/**
 *  @brief 测试有用户ID的时候，埋点事件是否正确
 *
 *  @since <#version number#>
 */
- (void)testClientWithUserId{
    [_client setUserId:MockUserId];
    [_client track:MockEventId];
    NSArray *array = [_cache fetchObjectAtDiskWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 1, @"array is empty");
    NSDictionary *dict = [array objectAtIndex:0];
    [self verfiyDict:dict];
    XCTAssertTrue([[dict objectForKey:@"user_id"] integerValue] == MockUserId, @"Invalid user_id value");
}

/**
 *  @brief 测试发送不带参数事件成功
 *
 *  @since <#version number#>
 */
- (void)testTrackEventWithoutAttr{
    [_client track:MockEventId];
    NSArray *array = [_cache fetchObjectAtDiskWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 1, @"array is empty");
    NSDictionary *dict = [array objectAtIndex:0];
    [self verfiyDict:dict];
}


/**
 *  @brief 测试发送带参数事件成功
 *
 *  @since <#version number#>
 */
- (void)testTrackEventWithAttr{
    NSDictionary *attr = @{@"attr":@"track_attr"};
    [_client track:MockEventId attributes:attr];
    NSArray *array = [_cache fetchObjectAtDiskWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 1, @"array is empty");
    NSDictionary *dict = [array objectAtIndex:0];
    [self verfiyDict:dict];
    
    //验证Param的值是否正确
    NSString *value = [[dict valueForKey:@"params"] valueForKey:@"attr"];
    XCTAssertTrue([value isEqualToString:@"track_attr"], @"Invalid event attributes");
}

/**
 *  @brief 测试立即发送带参数事件成功
 *
 *  @since <#version number#>
 */
- (void)testTrackEventWithAttrAndSendNow{
    NSDictionary *attr = @{@"attr":@"track_attr"};
    [_client track:MockEventId attributes:attr sendNow:YES];
    NSArray *array = [_cache fetchObjectAtDiskWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 0, @"array should be empty");
}

/**
 *  @brief 测试数据压缩的性能，准备50条数据
 *
 *  @since <#version number#>
 */
- (void)testCompressPerformanceExample {
    NSDictionary *attr = @{@"attr":@"track_attr"};
    for (int i=0; i<=49; i++) {
        [_client track:MockEventId attributes:attr];
    }
    [self measureBlock:^{
        [_client track:MockEventId attributes:attr];
    }];
}

- (void)verfiyDict:(NSDictionary *)dict{
    NSArray *keys = [dict allKeys];
    XCTAssertTrue([keys containsObject:@"type"], @"Missing type");
    XCTAssertTrue([keys containsObject:@"app"], @"Missing app");
    XCTAssertTrue([keys containsObject:@"version"], @"Missing version");
    XCTAssertTrue([keys containsObject:@"device"], @"Missing device");
    XCTAssertTrue([keys containsObject:@"user_id"], @"Missing user_id");
    XCTAssertTrue([keys containsObject:@"create_at"], @"Missing create_at");
    XCTAssertTrue([keys containsObject:@"params"], @"Missing params");
}

@end
