//
//  GMPhotoTest.m
//  GMPhobos
//
//  Created by Thierry on 16/1/28.
//  Copyright © 2016年 licong. All rights reserved.
//

#import <XCTest/XCTest.h>
#import <GMPhobos/Phobos.h>
#import <GMCache/WMCacheService.h>
#import "GMPhobosController.h"
#define PhobosCacheKey        @"PhobosCacheKey"

NSString      *const MockAppName      = @"gengmei_test";
NSString      *const MockChannelId    = @"AppStore";
NSString      *const MockEventId      = @"eventId";
NSString      *const MockUserId       = @"1";
NSString      *const MockCityId       = @"beijing";

@interface GMPhotoTest : XCTestCase
@property Phobos *client;
@property WMCacheService *cache;
@end

@implementation GMPhotoTest

- (void)setUp {
    [super setUp];
    _client = [Phobos clientWithAppName:MockAppName channelId:MockChannelId];
    [Phobos setSharedClient:_client];
    
    _cache = [WMCacheService sharedInstance];
}

- (void)tearDown {
    // Put teardown code here. This method is called after the invocation of each test method in the class.
    [super tearDown];
    [_cache removeObjectAtDucmentPathWithkey:PhobosCacheKey];
}

/**
 *  @brief 测试有用户ID的时候，埋点事件是否正确
 *
 *  @since <#version number#>
 */
- (void)testClientWithUserId{
    [_client setUserId:MockUserId];
    [_client setCurrentCityId:MockCityId];
    [Phobos track:MockEventId];
    NSArray *array = [_cache fetchObjectAtDucmentPathWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 1, @"array is empty");
    NSDictionary *dict = [array objectAtIndex:0];
    [self verfiyDict:dict];
    XCTAssertTrue([[dict objectForKey:@"user_id"] isEqualToString:MockUserId] , @"Invalid user_id value");
}

/**
 *  @brief 测试发送不带参数事件成功 (由之前的实例方法变成类方法)
 *
 *  @since <#version number#>
 */
- (void)testTrackEventWithoutAttr{
    [Phobos track:MockEventId];
    NSArray *array = [_cache fetchObjectAtDucmentPathWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 1, @"array is empty");
    NSDictionary *dict = [array objectAtIndex:0];
    [self verfiyDict:dict];
}


/**
 *  @brief 测试发送带参数事件成功
 *
 *  @since <#version number#>
 */
- (void)testTrackEventWithAttr{
    NSDictionary *attr = @{@"attr":@"track_attr"};
    [Phobos track:MockEventId attributes:attr];
    NSArray *array = [_cache fetchObjectAtDucmentPathWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 1, @"array is empty");
    NSDictionary *dict = [array objectAtIndex:0];
    [self verfiyDict:dict];
    
    //验证Param的值是否正确
    NSString *value = [[dict valueForKey:@"params"] valueForKey:@"attr"];
    XCTAssertTrue([value isEqualToString:@"track_attr"], @"Invalid event attributes");
}

/**
 *  @brief 测试立即发送带参数事件成功
 *
 *  @since <#version number#>
 */
- (void)testTrackEventWithAttrAndSendNow{
    // Given
    NSDictionary *attr = @{@"attr":@"track_attr"};
    // When
    [Phobos track:MockEventId attributes:attr sendNow:YES];
    // Then
    NSArray *array = [_cache fetchObjectAtDucmentPathWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count == 0, @"array should be empty");
}

- (void)verfiyDict:(NSDictionary *)dict{
    NSArray *keys = [dict allKeys];
    XCTAssertTrue([keys containsObject:@"type"], @"Missing type");
    XCTAssertTrue([keys containsObject:@"app"], @"Missing app");
    XCTAssertTrue([keys containsObject:@"version"], @"Missing version");
    XCTAssertTrue([keys containsObject:@"device"], @"Missing device");
    XCTAssertTrue([keys containsObject:@"user_id"], @"Missing user_id");
    XCTAssertTrue([keys containsObject:@"create_at"], @"Missing create_at");
    XCTAssertTrue([keys containsObject:@"params"], @"Missing params");
}

- (void)testCatchNullInAttributes {
    _client.captureNullExpection = ^(NSString *eventId, NSDictionary *att) {
        NSCAssert([att[@"bussness_id"] integerValue] == 1244, @"testCatchNullInAttributes 没有捕获到有用信息");
    };
    NSDictionary *attributes = @{@"key": [NSNull null],
                                 @"bussness_id": @1244};
    [Phobos track:@"testCatchNullInAttributes" attributes:attributes];
}

// 某种情况下没有先走 onPageStart，只走了OnPageEnd，此时数据应该完整，某个key对应的value可以是空
- (void)testOnPageStart {
    GMPhobosController *controller = [GMPhobosController new];
    controller.pageName = @"pageNameTest";
    controller.businessId = @"businessIdTest";
    controller.referrerId = @"rreferrerIdTest";
    [controller viewWillAppear:true];

    XCTAssertTrue(controller.inTime.integerValue > 0, "inTime 应该有值");
}

// 某种情况下没有先走 onPageStart，只走了OnPageEnd，此时数据应该完整，某个key对应的value可以是空
- (void)testOnPageEnd {
    GMPhobosController *controller = [GMPhobosController new];
    controller.pageName = @"pageNameTest";
    controller.businessId = @"businessIdTest";
    controller.referrerId = @"rreferrerIdTest";
    [controller viewWillAppear:true];
    [controller viewWillDisappear:true];
    [self paramUnNilCheck];
    NSArray *array = [[WMCacheService sharedInstance] fetchObjectAtDucmentPathWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count != 0, @"PhobosCacheKey 下面应该有数据");

    NSDictionary *dic = array[0][@"params"];
    XCTAssertTrue([dic[@"referrer_id"] isEqualToString:@"rreferrerIdTest"], @"referrerId至少使用默认的空字符串");

}

- (void)testSimulativePageViewEvent {
    [_client simulativePV:nil businessId:nil referer:nil];
    [self paramUnNilCheck];
}

- (void)paramUnNilCheck {
    NSArray *array = [[WMCacheService sharedInstance] fetchObjectAtDucmentPathWithkey:PhobosCacheKey];
    XCTAssertTrue(array.count != 0, @"PhobosCacheKey 下面应该有数据");

    NSDictionary *dic = array[0][@"params"];
    XCTAssertTrue(dic[@"page_name"] != nil, @"page_name至少使用默认的空字符串");
    XCTAssertTrue([dic[@"referer"] integerValue] >= 0, @"referer至少使用默认的空字符串");
    XCTAssertTrue(dic[@"business_id"] != nil, @"business_id至少使用默认的空字符串");
}

#pragma mark - 属性test

- (void)testNeedLogPV {
    UIViewController *controller = [UIViewController new];
    XCTAssertTrue(controller.needLogPV, @"needLogPV应该默认为YES");
    controller.needLogPV = NO;
    XCTAssertFalse(controller.needLogPV, @"needLogPV赋值为NO时应该NO");
}


#pragma mark - 其它方法test

- (void)testVisibleController {
    
}
@end
